/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.actionItems.cache;

import com.tandbergtv.cms.portal.util.locale.ResourceBundleLocaleModifier;
import com.tandbergtv.neptune.actionItems.cache.ICacheService;
import java.io.Serializable;
import java.util.Collection;
import java.util.ResourceBundle;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.aspectj.runtime.internal.AroundClosure;

public class CacheService<T>
implements ICacheService<T> {
    private Cache cache;
    private String name;

    public CacheService(String name) {
        this.name = name;
        String string = this.getClass().getPackage().getName() + ".cache";
        ResourceBundle bundle = CacheService.getBundle_aroundBody1$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
        int size = Integer.parseInt(bundle.getString("cache.size"));
        this.cache = new Cache(name, size, false, false, 0L, 0L);
    }

    public CacheService(String name, int size) {
        this.name = name;
        this.cache = new Cache(name, size, false, false, 0L, 0L);
    }

    @Override
    public void add(Serializable key, T entity) {
        this.cache.put(new Element((Object)key, entity));
    }

    @Override
    public T get(Serializable key) {
        Element e = this.cache.get(key);
        if (e == null) {
            return (T)((Object)null);
        }
        return (T)e.getValue();
    }

    @Override
    public void remove(Serializable key) {
        this.cache.remove(key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public int count() {
        return this.cache.getSize();
    }

    @Override
    public void start() {
        CacheManager.getInstance().addCache(this.cache);
    }

    @Override
    public void stop() {
        CacheManager.getInstance().removeCache(this.name);
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody0(CacheService cacheService, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody1$advice(CacheService ajc$this, String arg0, ResourceBundleLocaleModifier ajc$aspectInstance, String baseName, AroundClosure ajc$aroundClosure) {
        return ResourceBundle.getBundle(baseName, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc$aspectInstance));
    }
}

