/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authorization.ejb;

import com.tandbergtv.neptune.authorization.service.IModuleManager;
import com.tandbergtv.neptune.realm.persist.Module;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
@TransactionAttribute
public class ModuleManager
implements IModuleManager {
    @PersistenceContext(unitName="NeptuneRealm")
    EntityManager entityManager;

    public List<Module> getModules() {
        Query query = this.entityManager.createNamedQuery("Module.FindAllOrderByDisplayName");
        return query.getResultList();
    }

    public Module getModule(Long moduleId) {
        return (Module)this.entityManager.find(Module.class, (Object)moduleId);
    }

    public Module getModule(String name) {
        Module match = null;
        Query query = this.entityManager.createNamedQuery("Module.FindByName");
        query.setParameter("name", (Object)name);
        try {
            match = (Module)query.getSingleResult();
        }
        catch (NoResultException nre) {
            match = null;
        }
        return match;
    }
}

