package com.tandbergtv.neptune.ui.portalpage.client.portaluserpref;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * The Portal User Preferences Management Service that provides functionality to manage application user
 * preferences.
 */
@RemoteServiceRelativePath("service/realm/portalUserPreferenceService")
public interface PortalUserPreferenceService extends RemoteService {

	/**
	 * Creates a Portal User Preference based on the given parameter
	 * 
	 * @param uiPortalUserPreference the Portal User Preference
	 * @return the created Portal User Preference
	 */
	UiPortalUserPreference create(UiPortalUserPreference uiPortalUserPreference) throws NeptuneException;

	/**
	 * Creates Portal User Preferences based on the given list parameter
	 * 
	 * @param uiPortalUserPreferences the list of Portal User Preferences
	 * @return the list of created Portal User Preferences
	 */
	List<UiPortalUserPreference> create(List<UiPortalUserPreference> uiPortalUserPreferences) throws NeptuneException;

	/**
	 * Saves the given Portal User Preference
	 * 
	 * @param uiPortalUserPreference the Portal User Preference
	 * @return the saved Portal User Preference
	 */
	UiPortalUserPreference save(UiPortalUserPreference uiPortalUserPreference) throws NeptuneException;

	/**
	 * Retrieves a list of Portal User Preferences
	 * 
	 * @return the list of Portal User Preferences found
	 */
	List<UiPortalUserPreference> getPreferences() throws NeptuneException;

	/**
	 * Retrieve the Portal User Preference with the given component, type and key
	 * 
	 * @param component the component name
	 * @param key the Portal User Preference key
	 * @return the Portal User Preference found or null if not found
	 */
	UiPortalUserPreference getPreference(String component, String key)
	        throws NeptuneException;

	/**
	 * Deletes the Portal User Preferences with the given component
	 * 
	 * @param component the component name
	 */
	void deletePreferences(String component) throws NeptuneException;

	/**
	 * Delete the Portal User Preference with the given component and key
	 * 
	 * @param component the component name
	 * @param key the User Preference key
	 */
	void deletePreference(String component, String key)
	        throws NeptuneException;

	/**
	 * Update the preferences for the current user for the given component and key to be the new
	 * set of provided preferences
	 * 
	 * @param component the component name
	 * @param key the User Preference key
	 * @param preferences The preferences
	 */
	void updatePreferences(List<UiPortalUserPreference> preferences)
	        throws NeptuneException;
}
