package com.tandbergtv.neptune.ui.portalpage.client.ui;

import com.google.gwt.event.shared.GwtEvent;

public class GadgetCloseEvent extends GwtEvent<GadgetCloseHandler> {
    public static Type<GadgetCloseHandler> TYPE = new Type<GadgetCloseHandler>();
    private HasGadgetCloseHandlers source;
    
    public GadgetCloseEvent(HasGadgetCloseHandlers source) {
    	this.source = source;
    }
    
    /**
     * Fires a layout event on all registered handlers in the handler
     * manager.If no such handlers exist, this method will do nothing.
     *
     * @param source the source of the handlers
     */
    public static void fire(HasGadgetCloseHandlers source) {
        if (TYPE != null) {
            source.fireEvent(new GadgetCloseEvent(source));
        }
    }

    public Type<GadgetCloseHandler> getAssociatedType() {
        return TYPE;
    }

    protected void dispatch(GadgetCloseHandler handler) {
        handler.onGadgetClosed(this);
    }
    
    public HasGadgetCloseHandlers getSource() {
    	return source;
    }
}
