package com.tandbergtv.neptune.ui.portalpage.client.ui;

import java.util.ArrayList;
import java.util.List;

import org.gwtportlets.portlet.client.edit.row.RowLayoutEditor;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

import org.gwtportlets.portlet.client.layout.Container;
import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.layout.LayoutConstraints;
import org.gwtportlets.portlet.client.layout.RowLayout;


/*
 * Manage the columns so that whenever a column is resized,
 * The other columns are resized to maintain a max of 100% window width
 */
public class ColumnContainerEditor extends RowLayoutEditor {

	private static float MIN_WIDTH = 0.01f;   // enforce min 1% for fixed-percent-sized columns
	private static float MAX_WIDTH = 0.999f;
	
	public ColumnContainerEditor() {
		super();
	}
	
	@Override
    public void resizeWidget(Widget target, int delta) {
        if (delta == 0) {
            return;
        }

        Container container = getContainer();
        Element ce = container.getElement();
        int containerSize = getTargetLayout().isColumn()
                ? LDOM.getContentHeight(ce)
                : LDOM.getContentWidth(ce);

        RowLayout.Constraints c =
                (RowLayout.Constraints)container.getLayoutConstraints(target);
        if (c.getMaxSize() > 0 && c.getActualSize() == c.getMaxSize()) {
            // change the max size if the widget is at max
            int sz = c.getMaxSize() + delta;
            if (sz < 10) {
                sz = 10;
            }
            c.setMaxSize(sz);
        } else {
            int sz = c.getActualSize() - c.getExtraSize() + delta;
            if (sz <= 0) {
                sz = 1;
            }
            if (c.getSize() < 1.0f) { // set new proportional size
                float f = (float)sz / containerSize;
                int numColumns = container.getWidgetCount();
                float maxAllowed = getMaxAllowedSize(numColumns);
                c.setSize(f > maxAllowed ? maxAllowed : f);
                
                // Maintain <= 100% screen width shared among all columns except last
                //    (last column grows to fit whatever space is left, if any)
                List<RowLayout.Constraints> adjustConstraints = new ArrayList<RowLayout.Constraints>();
                float totalPercentage = c.getSize();
                for (int i=0; i<numColumns; i++) {
                	Widget nextColumn = container.getWidget(i);
                	if (nextColumn != target) {
	                	RowLayout.Constraints nextConstraints =
	                		(RowLayout.Constraints) container.getLayoutConstraints(nextColumn);
	                	float nextSize = nextConstraints.getSize(); 
	                	// we only care about columns that are a percentage size
	                	if (nextSize < 1.0f && nextSize >= MIN_WIDTH) {
	                		totalPercentage += nextSize;
	                		adjustConstraints.add(nextConstraints);
	                	}
                	}
                }
                // New size makes everything too wide, resize other columns to accommodate
                while (totalPercentage > 1 && adjustConstraints.size() > 0) {
                	// we try to reduce the remaining columns by the same %
                	int numAdjustableColumns = adjustConstraints.size();
                	float adjustSz = (totalPercentage-1f) / numAdjustableColumns;
                	for (int i=0; i<adjustConstraints.size(); i++) {
                		RowLayout.Constraints adjustC = adjustConstraints.get(i);
                		if (adjustC.getSize()-MIN_WIDTH < adjustSz) {
                			// oops, this column is too small to accommodate it's fair share
                			totalPercentage -= (adjustC.getSize()-MIN_WIDTH);
                			adjustC.setSize(MIN_WIDTH);
                			adjustConstraints.remove(i);
                			break;   // try again with remaining columns
                		}
                		adjustC.setSize(adjustC.getSize() - adjustSz);
                		totalPercentage -= adjustSz;
                	}                	
                }
                
            } else { // set new pixel size
                c.setSize(sz);
            }
        }

        container.layout();
    }

	// Don't let the target column be sized larger than the window width
	// Each of the other columns (except the last "GROW" column) must be at least MIN_WIDTH
	private float getMaxAllowedSize(int totalColumns) {
		return (totalColumns < 3) ? MAX_WIDTH : (MAX_WIDTH - MIN_WIDTH*(totalColumns-2));
	}

	/*
	 * When swapping columns, we keep the original constraints
	 *  i.e. we are really just swapping the Gadgets in the column & not changing column size
	 * @see org.gwtportlets.portlet.client.edit.row.RowLayoutEditor#dropWidget(com.google.gwt.user.client.ui.Widget, org.gwtportlets.portlet.client.layout.LayoutConstraints, java.lang.String, int, int)
	 */
	@Override
    public boolean dropWidget(Widget widget, LayoutConstraints constraints,
            String overflow, int clientX, int clientY) {

		// Save and restore the original layout constraints
		Container container = getContainer();
		List<LayoutConstraints> constraintList = new ArrayList<LayoutConstraints>();
		for (int i=0; i< container.getWidgetCount(); i++) {
			constraintList.add(container.getLayoutConstraints(container.getWidget(i)));
		}
		boolean result = super.dropWidget(widget, constraints, overflow, clientX, clientY);
		if (result) {
			for (int i=0; i< container.getWidgetCount(); i++) {
				container.setLayoutConstraints(container.getWidget(i), constraintList.get(i));
			}			
		}
		return result;
	}

}
