/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.service;

import com.tandbergtv.neptune.configuration.settings.entity.ComplexSetting;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class SettingToJSONConverter {
    private static final String ARRAY_CLOSE = "]";
    private static final String ARRAY_OPEN = "[";
    private static final String SETTING_PATH_SEPARATOR = ".";
    private SettingGroup group;
    private ObjectMapper mapper;
    private Map<String, String> settingsValues;
    private Map<String, Integer> arrayLength;

    public SettingToJSONConverter(SettingGroup group, Map<String, String> values) {
        this.group = group;
        this.settingsValues = values;
        this.mapper = new ObjectMapper();
        this.buildComplexSettingArrayLength();
    }

    public ObjectNode convert() {
        ObjectNode root = this.mapper.createObjectNode();
        if (this.group != null) {
            root = this.convert(null, this.group.getSettings());
        }
        return root;
    }

    protected int getComplexSettingArrayLength(String path) {
        Integer length = this.arrayLength.get(path);
        if (length == null) {
            length = 0;
            this.arrayLength.put(path, length);
        }
        return this.arrayLength.get(path);
    }

    protected void buildComplexSettingArrayLength() {
        this.arrayLength = new HashMap<String, Integer>();
        for (String key : this.settingsValues.keySet()) {
            int i = key.indexOf(ARRAY_OPEN, 0);
            while (i != -1) {
                String arrayIndexStr;
                int arrayIndex;
                int arraySize;
                String varPath = key.substring(0, i);
                Integer length = this.arrayLength.get(varPath);
                if (length == null) {
                    length = 0;
                    this.arrayLength.put(varPath, length);
                }
                if ((arraySize = (arrayIndex = Integer.parseInt(arrayIndexStr = key.substring(i + 1, key.indexOf(ARRAY_CLOSE, i)))) + 1) > length) {
                    this.arrayLength.put(varPath, arraySize);
                }
                i = key.indexOf(ARRAY_OPEN, i + 1);
            }
        }
    }

    protected ObjectNode convert(String parent, List<SettingDefinition> settings) {
        ObjectNode node = this.mapper.createObjectNode();
        for (SettingDefinition def : settings) {
            String settingFullPath = def.getName();
            if (parent != null) {
                settingFullPath = parent + SETTING_PATH_SEPARATOR + def.getName();
            }
            if (def instanceof ComplexSetting) {
                ComplexSetting complex = (ComplexSetting)def;
                if (parent != null && (complex.getMax() == null || complex.getMax() > 1)) {
                    int arrayLength = this.getComplexSettingArrayLength(settingFullPath);
                    ArrayNode array = this.mapper.createArrayNode();
                    for (int i = 0; i < arrayLength; ++i) {
                        String currentPath = settingFullPath + ARRAY_OPEN + i + ARRAY_CLOSE;
                        array.add((JsonNode)this.convert(currentPath, complex.getSettings()));
                    }
                    node.put(def.getName(), (JsonNode)array);
                    continue;
                }
                node.put(def.getName(), (JsonNode)this.convert(settingFullPath, complex.getSettings()));
                continue;
            }
            node.put(def.getName(), this.settingsValues.get(settingFullPath));
        }
        return node;
    }
}

