/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external;

import com.tandbergtv.neptune.realm.persist.UserConfigurationMode;
import com.tandbergtv.neptune.usermgmt.external.IExternalUserProvider;
import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class UserConfigurationFactory {
    private static final Logger logger = Logger.getLogger(UserConfigurationFactory.class);
    private static UserConfigurationFactory FACTORY = null;
    private static UserConfigurationFactory INTERNAL_FACTORY = null;
    private static final String DEFAULT_FACTORY_CLASS = "com.tandbergtv.neptune.usermgmt.internal.LocalUserConfigurationFactory";
    private static final String PRODUCT_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String RELATIVE_CONFIG_FOLDER_PATH = "conf/neptune";
    private static final String CONFIG_FILE_NAME = "neptune.properties";

    protected UserConfigurationFactory() {
    }

    public static final synchronized UserConfigurationFactory getFactory() {
        if (FACTORY == null) {
            String className = UserConfigurationFactory.getFactoryClassName();
            FACTORY = UserConfigurationFactory.createFactory(className);
            logger.info((Object)("Created UserConfigurationFactory[" + FACTORY.getClass().getName() + "] with mode: " + (Object)((Object)FACTORY.getUserConfigurationMode())));
        }
        return FACTORY;
    }

    public static final synchronized UserConfigurationFactory getInternalModeFactory() {
        if (INTERNAL_FACTORY == null) {
            String className = DEFAULT_FACTORY_CLASS;
            INTERNAL_FACTORY = UserConfigurationFactory.createFactory(className);
        }
        return INTERNAL_FACTORY;
    }

    public static final File getProductDirectory() {
        String productPath = System.getProperty(PRODUCT_FOLDER_PROPERTY);
        if (productPath == null) {
            throw new RuntimeException("The product folder path property[com.tandbergtv.cms.product.dir] is not configured.");
        }
        return new File(productPath);
    }

    public static final File getNeptuneConfigurationDirectory() {
        return new File(UserConfigurationFactory.getProductDirectory(), RELATIVE_CONFIG_FOLDER_PATH);
    }

    private static UserConfigurationFactory createFactory(String className) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Object instance = classLoader.loadClass(className).newInstance();
            return (UserConfigurationFactory)UserConfigurationFactory.class.cast(instance);
        }
        catch (Exception e) {
            String msg = "Failed to instantiate UserConfigurationFactory implementation class: " + className + ", error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
    }

    private static String getFactoryClassName() {
        String className = UserConfigurationFactory.getFactoryClassNameFromConfiguration();
        if (className == null || className.trim().isEmpty()) {
            className = System.getProperty(UserConfigurationFactory.class.getName());
        }
        if (className == null || className.trim().isEmpty()) {
            className = DEFAULT_FACTORY_CLASS;
        }
        return className.trim();
    }

    private static String getFactoryClassNameFromConfiguration() {
        String className = null;
        File configFile = new File(UserConfigurationFactory.getNeptuneConfigurationDirectory(), CONFIG_FILE_NAME);
        try {
            if (configFile.exists() && configFile.isFile()) {
                Properties properties = new Properties();
                properties.load(new FileReader(configFile));
                className = properties.getProperty(UserConfigurationFactory.class.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load properties file: " + configFile.getAbsolutePath(), e);
        }
        return className;
    }

    public abstract UserConfigurationMode getUserConfigurationMode();

    public abstract IUserAuthenticationService createUserAuthenticationService();

    public abstract IExternalUserProvider createExternalUserProvider();

    public boolean allowCreateInternalUser() {
        return false;
    }
}

