/**
 *
 */
package com.tandbergtv.neptune.ui.realm.client.tab.user.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserConfiguration;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserList;

/**
 * @author spuranik
 * @generated generated asynchronous callback interface to be used on the client side
 */
public interface UserUiServiceAsync {

    /**
     * @param callback the callback that will be called to receive the return value
     * @generated generated method with asynchronous callback parameter to be used on the client
     *            side
     */
    void listUsers(int startIndex, int pageSize, String sortByProperty, boolean isAscending,
            AsyncCallback<UiUserList> callback);

    /**
     * @param callback the callback that will be called to receive the return value
     * @generated generated method with asynchronous callback parameter to be used on the client
     *            side
     */
    void deleteUsers(List<UiUserKey> userKeys, AsyncCallback<?> callback);

    /**
     * @param callback the callback that will be called to receive the return value
     * @generated generated method with asynchronous callback parameter to be used on the client
     *            side
     */
    void getUser(UiUserKey userKey, AsyncCallback<UiUser> callback);

    /**
     * @param callback the callback that will be called to receive the return value
     * @generated generated method with asynchronous callback parameter to be used on the client
     *            side
     */
    void getUser(String userName, AsyncCallback<UiUser> callback);

    /**
     * @param callback the callback that will be called to receive the return value
     * @generated generated method with asynchronous callback parameter to be used on the client
     *            side
     */
    void saveUser(UiUser user, AsyncCallback<UiUser> callback);

    void getRoles(AsyncCallback<List<UiRole>> callback);

    void getUserConfiguration(AsyncCallback<UiUserConfiguration> callback);

    void listExternalUsers(String filterCriteria, int startIndex, int pageSize,
            String sortByProperty, boolean isAscending, AsyncCallback<UiUserList> callback);

    void getExternalUser(String externalKey, AsyncCallback<UiUser> callback);

    void getAccessToken(AsyncCallback<String> callback);
}
