package com.tandbergtv.neptune.ui.framework.client;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.AuthenticationException;

/**
 * Internal service that performs user login / logout
 * 
 * @author Vijay Silva
 */
@RemoteServiceRelativePath("service/loginService")
public interface LoginUiService extends RemoteService {

	/**
	 * Log the user into the application.
	 * 
	 * @param username The user name
	 * @param password The user password
	 * @return The list of EJB3 roles assigned to the user if authentication is successful
	 * @throws NeptuneException
	 */
	List<String> login(String username, String password) throws NeptuneException;

	/**
	 * Log the currently logged-in user out of the application.
	 * 
	 * @throws NeptuneException
	 */
	void logout() throws NeptuneException;

	/**
	 * Get the credentials of the currently logged in user.
	 * 
	 * @return The logged-in user credentials
	 * @throws AuthenticationException Error is no user is currently logged in
	 */
	Credentials getCredentials() throws NeptuneException;
}
