package com.tandbergtv.neptune.widgettoolkit.client.util;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;

public class FormatUtil {

    private static final String[] UNITS = new String[] { "B", "KB", "MB", "GB", "TB" };

    private static final Map<String, Double> unitInBytes;

    private static final RegExp HUMAN_READABLE_SIZE_EXP = RegExp.compile("(\\d+(\\.\\d+)?)\\s*([kKmMgGtT]?[bB]?)?");

    static {
        unitInBytes = new HashMap<String, Double>();
        unitInBytes.put("b", 1.0);
        unitInBytes.put("k", 1024.0);
        unitInBytes.put("kb", 1024.0);
        unitInBytes.put("m", 1048576.0);
        unitInBytes.put("mb", 1048576.0);
        unitInBytes.put("g", 1073741824.0);
        unitInBytes.put("gb", 1073741824.0);
        unitInBytes.put("t", 1099511627776.0);
        unitInBytes.put("tb", 1099511627776.0);
    }

    /**
     * Format the numeric bytes to string with units, for example 1024 will be 1K.
     *
     * @param bytes
     * @return
     */
    public static String formatBytes(double bytes) {
        if (bytes <= 0) {
            return "0";
        }
        int digitGroups = (int) (Math.log10(bytes) / Math.log10(1024));
        return NumberFormat.getFormat("#,##0.#").format(bytes / Math.pow(1024, digitGroups)) + " " + UNITS[digitGroups];
    }

    /**
     * Get the value in bytes from a human readable size, for example 1.5 K will be 1536.
     *
     * @param humanReadable
     * @return
     * @throws NumberFormatException
     */
    public static double getBytes(String humanReadable) throws NumberFormatException {
        MatchResult mr = HUMAN_READABLE_SIZE_EXP.exec(humanReadable);
        if (mr == null) {
            throw new NumberFormatException("Invalid file size: " + humanReadable);
        }
        return Double.parseDouble(mr.getGroup(1)) * unitInBytes.get(mr.getGroup(3).toLowerCase());
    }
}
