package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * @author esunpur
 *
 */
public class MessagePanel extends Composite {

	private static final String MESSAGE_PANEL_STYLE = "nwt-MessagePanel"; 
	private static final String MESSAGE_LABEL_STYLE = "nwt-Message"; 

	protected ScrollPanel scrollPanel;
	protected VerticalPanel mainPanel;
	protected Label messageLabel;
	
	public MessagePanel() {
		scrollPanel = new ScrollPanel();
		scrollPanel.addStyleName(MESSAGE_PANEL_STYLE);
		
		mainPanel = new VerticalPanel();
		messageLabel = new Label();
		messageLabel.addStyleName(MESSAGE_LABEL_STYLE);
		mainPanel.add(messageLabel);
		
		scrollPanel.add(mainPanel);
		initWidget(scrollPanel);
	}

	public void reset() {
		messageLabel.setText(null);
	}

	/**
	 * 
	 * @param text
	 */
	public void setText(String text) {
		messageLabel.setText(text);
	}	
}
