/*
 * Created on May 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter;

/**
 * Converts a value from float to string and vice versa
 * 
 * @author Vijay Silva
 */
public class FloatConverter implements IValueConverter<String> {

	/**
	 * Constructor
	 */
	public FloatConverter() {
	}

	@Override
	public String getStringValue(String typedValue) {
		return typedValue;
	}

	@Override
	public String getTypedValue(String value) throws ValueFormatException {
		Float result = null;

		try {
			if (value != null && value.trim().length() > 0) {
				result = new Float(value.trim());
			}
		} catch (NumberFormatException nfe) {
			throw new ValueFormatException(value + " is not a valid float.");
		}

		return (result != null) ? result.toString() : null;
	}
}
