/*
 * Created on May 18, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.user.datepicker.client.CalendarModel;
import com.google.gwt.user.datepicker.client.CalendarView;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.google.gwt.user.datepicker.client.DefaultCalendarView;
import com.google.gwt.user.datepicker.client.DefaultMonthSelector;
import com.google.gwt.user.datepicker.client.MonthSelector;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link DatePicker} widget.
 * 
 * @see com.google.gwt.user.datepicker.client.DatePicker
 * @author Vijay Silva
 */
public class DatePickerWidget extends DatePicker implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.datepicker.client.DatePicker#DatePicker()
	 */
	public DatePickerWidget() {
		this(new DefaultMonthSelector(), new DefaultCalendarView(), new CustomCalendarModel());
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.datepicker.client.DatePicker#DatePicker(MonthSelector, CalendarView,
	 *      CalendarModel)
	 */
	protected DatePickerWidget(MonthSelector monthSelector, CalendarView view, CalendarModel model) {
		super(monthSelector, view, model);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
