/*
 * Created on May 18, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link SuggestBox} widget.
 * 
 * @see com.google.gwt.user.client.ui.SuggestBox
 * @author Vijay Silva
 */
public class SuggestBoxWidget extends SuggestBox implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SuggestBox#SuggestBox()
	 */
	public SuggestBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SuggestBox#SuggestBox(SuggestOracle)
	 */
	public SuggestBoxWidget(SuggestOracle oracle) {
		super(oracle);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SuggestBox#SuggestBox(SuggestOracle, TextBoxBase)
	 */
	public SuggestBoxWidget(SuggestOracle oracle, TextBoxBase box) {
		super(oracle, box);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.SuggestBox#wrap(SuggestOracle, Element)
	 */
	public static SuggestBoxWidget wrap(SuggestOracle oracle, Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		TextBoxWidget textBox = new TextBoxWidget(element);
		SuggestBoxWidget suggestBox = new SuggestBoxWidget(oracle, textBox);
		suggestBox.onAttach();
		RootPanel.detachOnWindowClose(suggestBox);
		return suggestBox;
	}
}
