/*
 * Created on Jan 7, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

/**
 * Event that indicates that the detail view is being displayed by the table widget
 * 
 * @author Vijay Silva
 */
public class TableDetailViewEvent<K, R extends Record<K>> extends TableViewEvent {

	/* The record displayed by the view */
	private R record;
	private boolean create;

	/**
	 * @param create Flag indicating if view is for new record or an existing record
	 * @param record The record
	 */
	public TableDetailViewEvent(boolean create, R record) {
		this.create = create;
		this.record = record;
	}

	/**
	 * Get the record associated with the detail view
	 * 
	 * @return the record
	 */
	public R getRecord() {
		return record;
	}

	/**
	 * Determine if the view is for a newly created record
	 * 
	 * @return true if for newly created record, false if for existing record
	 */
	public boolean isCreateView() {
		return create;
	}
}
