/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.component.services;

import com.ericsson.neptune.component.entity.IComponent;
import com.ericsson.neptune.component.entity.IMenuItem;
import com.ericsson.neptune.component.entity.IPortlet;
import com.ericsson.neptune.component.services.ComponentRegistrationDataServer;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleSynchronizer;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;

public class NeptuneComponentServicesApplication
extends Application {
    private IModuleSynchronizer moduleSyncService = null;
    HashSet<Object> singletons = new HashSet();
    HashSet<Class<?>> classes = new HashSet();
    ComponentRegistrationDataServer regService = new ComponentRegistrationDataServer();

    public NeptuneComponentServicesApplication() {
        IComponent component = this.getModuleSyncService().getComponent();
        this.addNamedLocations(component.getNamedLocations());
        this.setMenus(component.getMenus());
        this.addPortlets(component.getPortlets());
        for (IModule module : component.getModules()) {
            this.addModule(module);
        }
        this.singletons.add(this.regService);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    private void setMenus(List<IMenuItem> menus) {
        this.regService.setMenus(menus);
    }

    private void addPortlets(List<IPortlet> portlets) {
        this.regService.addPortlets(portlets);
    }

    private void addModule(IModule module) {
        this.regService.addModule(module);
    }

    private void addNamedLocations(Map<String, String> namedLocations) {
        for (Map.Entry<String, String> namedLocation : namedLocations.entrySet()) {
            this.regService.setLocation(namedLocation.getKey(), namedLocation.getValue());
        }
    }

    private IModuleSynchronizer getModuleSyncService() {
        if (this.moduleSyncService == null) {
            this.moduleSyncService = (IModuleSynchronizer)InjectionUtil.injectInstance((String)"cms/ModuleSynchronizer/local", IModuleSynchronizer.class);
        }
        return this.moduleSyncService;
    }
}

