/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authorization.ejb;

import com.ericsson.neptune.component.entity.BasicComponent;
import com.ericsson.neptune.component.entity.IComponent;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import com.tandbergtv.neptune.authorization.service.IExternalModuleProvider;
import com.tandbergtv.neptune.authorization.service.IModuleSynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class ModuleSynchronizer
implements IModuleSynchronizer {
    private static final Logger logger = Logger.getLogger(ModuleSynchronizer.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("\\p{Alnum}+");
    private static final String NEW_LINE = System.getProperty("line.separator");

    public IComponent getComponent() {
        BasicComponent component = new BasicComponent();
        HashMap<String, List<ComponentModule>> moduleMap = new HashMap<String, List<ComponentModule>>();
        ServiceLoader<IExternalModuleProvider> providerLoader = ServiceLoader.load(IExternalModuleProvider.class);
        for (IExternalModuleProvider moduleProvider : providerLoader) {
            List menus;
            List portlets;
            Map namedLocations;
            Collection providedModules = moduleProvider.getModules();
            if (providedModules != null) {
                for (IModule module : providedModules) {
                    String moduleName = module.getName();
                    ComponentModule componentModule = new ComponentModule(moduleProvider, module);
                    ArrayList<ComponentModule> componentModules = (ArrayList<ComponentModule>)moduleMap.get(moduleName);
                    if (componentModules == null) {
                        componentModules = new ArrayList<ComponentModule>();
                        moduleMap.put(moduleName, componentModules);
                    }
                    componentModules.add(componentModule);
                }
            }
            if ((namedLocations = moduleProvider.getNamedLocations()) != null) {
                component.getNamedLocations().putAll(namedLocations);
            }
            if ((portlets = moduleProvider.getPortlets()) != null) {
                component.getPortlets().addAll(portlets);
            }
            if ((menus = moduleProvider.getMenuItems()) == null) continue;
            component.getMenus().addAll(menus);
        }
        this.discardInvalidModules(moduleMap);
        HashMap<String, IModule> validModuleMap = new HashMap<String, IModule>();
        for (String moduleName : moduleMap.keySet()) {
            List componentModules = (List)moduleMap.get(moduleName);
            validModuleMap.put(moduleName, ((ComponentModule)componentModules.get(0)).module);
        }
        component.setModules(validModuleMap.values());
        return component;
    }

    private void discardInvalidModules(Map<String, List<ComponentModule>> moduleMap) {
        HashSet<String> invalidModuleNames = new HashSet<String>();
        StringBuilder errorReport = new StringBuilder();
        errorReport.append("Module synchronization error report: ");
        errorReport.append(NEW_LINE);
        for (String moduleName : moduleMap.keySet()) {
            int permissionCount;
            List<ComponentModule> componentModules = moduleMap.get(moduleName);
            if (componentModules.size() > 1) {
                invalidModuleNames.add(moduleName);
                errorReport.append("\tModule[name='").append(moduleName);
                errorReport.append("', providerImpl={");
                boolean first = true;
                for (ComponentModule componentModule : componentModules) {
                    if (first) {
                        first = false;
                    } else {
                        errorReport.append(", ");
                    }
                    errorReport.append(componentModule.moduleProvider.getClass().getName());
                }
                errorReport.append("}] does not have a unique name(");
                errorReport.append(componentModules.size());
                errorReport.append(" duplicates).");
                errorReport.append(NEW_LINE);
                continue;
            }
            if (moduleName == null || !NAME_PATTERN.matcher(moduleName).matches()) {
                invalidModuleNames.add(moduleName);
                errorReport.append("\t").append(componentModules.get(0));
                errorReport.append(" does not have a valid name, ");
                errorReport.append("the name must consist of 1 or more alphanumeric characters.");
                errorReport.append(NEW_LINE);
                continue;
            }
            ComponentModule componentModule = componentModules.get(0);
            List permissions = componentModule.module.getPermissions();
            int n = permissionCount = permissions == null ? 0 : permissions.size();
            if (permissionCount == 0) {
                invalidModuleNames.add(moduleName);
                errorReport.append("\t").append(componentModule);
                errorReport.append(" does not have any permissions.");
                errorReport.append(NEW_LINE);
                continue;
            }
            for (IPermission permission : permissions) {
                String name = permission.getName();
                if (name != null && NAME_PATTERN.matcher(name).matches()) continue;
                invalidModuleNames.add(moduleName);
                errorReport.append("\t").append(componentModule);
                errorReport.append(" contains a permission with invalid name: '");
                errorReport.append(name).append("', ");
                errorReport.append("the name must consist of 1 or more ");
                errorReport.append("alphanumeric characters.");
                errorReport.append(NEW_LINE);
            }
        }
        if (invalidModuleNames.size() > 0) {
            logger.error((Object)errorReport.toString());
            for (String name : invalidModuleNames) {
                moduleMap.remove(name);
            }
        }
    }

    private class ComponentModule {
        private IExternalModuleProvider moduleProvider;
        private IModule module;

        public ComponentModule(IExternalModuleProvider moduleProvider, IModule module) {
            this.moduleProvider = moduleProvider;
            this.module = module;
        }

        public String toString() {
            String desc = "Module[name='" + this.module.getName() + "', providerImpl=" + this.moduleProvider.getClass().getName() + "]";
            return desc;
        }
    }
}

