/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.rolemgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import com.tandbergtv.neptune.realm.search.EntitySearchService;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.IRoleValidityService;
import com.tandbergtv.neptune.rolemgmt.service.RoleValidationException;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Local(value={IRoleManager.class})
@Stateless
@TransactionAttribute
public class RoleManager
implements IRoleManager {
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    @EJB
    protected IRealmConfigurationService realmConfiguration;
    private EntitySearchService<Role> searchService = new EntitySearchService<Role>(Role.class, Role.ID_FIELD_NAME);

    @PageTarget(entityClass="Role", entityName="role")
    public List<Role> getRoles() {
        Query query = this.entityManager.createQuery("SELECT role FROM Role role");
        return query.getResultList();
    }

    public SearchResult<Role> getRoles(SearchMetadata searchMetadata) {
        return this.searchService.getSearchResult(this.entityManager, "role", null, null, searchMetadata);
    }

    public Role getRole(RoleKey roleKey) {
        return this.find(roleKey.getId());
    }

    public Role getRole(String name) {
        Query query = this.entityManager.createNamedQuery("Role.FindByName");
        query.setParameter("roleName", (Object)name);
        Role role = null;
        try {
            role = (Role)query.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return role;
    }

    public Role createRole(Role role) throws ValidationException {
        this.validate(role);
        this.entityManager.persist((Object)role);
        return role;
    }

    public Role updateRole(Role role) throws ValidationException {
        this.validate(role);
        return (Role)this.entityManager.merge((Object)role);
    }

    public boolean deleteRole(RoleKey roleKey) throws ValidationException {
        Integer userCount = this.getRole(roleKey).getUserCount();
        if (userCount != null && userCount > 0) {
            ArrayList<String> validationMessages = new ArrayList<String>();
            validationMessages.add("There are users associated with this role.");
            throw new ValidationException(validationMessages);
        }
        Role role = this.find(roleKey.getId());
        if (role != null) {
            if (this.isReadOnly(role)) {
                String errorMessage = "The role '" + role.getName() + "' is read-only, cannot delete the role.";
                throw new RuntimeException(errorMessage);
            }
            if (role.getUserCount() == 0) {
                this.entityManager.remove((Object)role);
            } else {
                String errorMessage = "Cannot delete role '" + role.getName() + "' since there are still users associated with it.";
                throw new RuntimeException(errorMessage);
            }
        }
        return role != null;
    }

    public boolean deleteRoles(RoleKey ... roleKeys) {
        boolean result = true;
        for (RoleKey roleKey : roleKeys) {
            try {
                result &= this.deleteRole(roleKey);
            }
            catch (ValidationException e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    public Role assignAllPermissions(RoleKey roleKey) {
        Role role = this.getRole(roleKey);
        Query query = this.entityManager.createNamedQuery("Permission.FindAll");
        List permissions = query.getResultList();
        for (Object permission : permissions) {
            role.getPermissions().add((Permission)permission);
        }
        return role;
    }

    @Deprecated
    public boolean isReadOnly() {
        return false;
    }

    @Deprecated
    public boolean isReadOnly(Role role) {
        return role != null && this.getAdministratorRoleKeys().contains(role.getRoleKey());
    }

    public List<RoleKey> getAdministratorRoleKeys() {
        return this.realmConfiguration.getAdministratorRoleKeys();
    }

    public List<Role> getAdministratorRoles() {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (RoleKey key : this.getAdministratorRoleKeys()) {
            Role role = this.getRole(key);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    private Role find(Long roleId) {
        return (Role)this.entityManager.find(Role.class, (Object)roleId);
    }

    private void validate(Role role) throws ValidationException {
        Role existingRole;
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.getAdministratorRoleKeys().contains(role.getRoleKey())) {
            validationMessages.add("Role is read-only.");
        }
        if (this.isBlank(role.getName())) {
            validationMessages.add("Name is required.");
        }
        if ((existingRole = this.getRole(role.getName())) != null && !existingRole.equals((Object)role)) {
            validationMessages.add("Name already exists.");
        }
        this.validateWithComponents(role, validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateWithComponents(Role role, List<String> validationMessages) throws ValidationException {
        Query query = this.entityManager.createQuery("SELECT permission FROM Permission permission");
        List permissions = query.getResultList();
        HashMap<Long, Permission> permissionIdMap = new HashMap<Long, Permission>();
        for (Permission perm : permissions) {
            permissionIdMap.put(perm.getId(), perm);
        }
        HashSet<Permission> completePermissions = new HashSet<Permission>();
        for (Permission permission : role.getPermissions()) {
            Permission completePermission = (Permission)permissionIdMap.get(permission.getId());
            completePermissions.add(completePermission);
        }
        role.setPermissions(completePermissions);
        ServiceLoader<IRoleValidityService> loader = ServiceLoader.load(IRoleValidityService.class);
        for (IRoleValidityService service : loader) {
            try {
                service.validate(role);
            }
            catch (RoleValidationException e) {
                validationMessages.add(e.getLocalizedMessage());
            }
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public List<Long> getPermissionByName(Set<String> name) {
        Query query = this.entityManager.createNamedQuery("Permission.FindByName");
        query.setParameter("fullpermission", name);
        List permissionList = query.getResultList();
        return permissionList;
    }

    public Map<String, Long> getRoleNameIdMap(Set<String> roleNames) {
        Query query = this.entityManager.createNamedQuery("Role.FindAllIdsByNames");
        query.setParameter("roleNames", roleNames);
        List roleIdList = query.getResultList();
        HashMap<String, Long> roleIdName = new HashMap<String, Long>();
        for (Object[] objects : roleIdList) {
            roleIdName.put((String)objects[0], (Long)objects[1]);
        }
        return roleIdName;
    }
}

