/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.componentmgr.ejb;

import com.ericsson.neptune.componentmgr.ejb.ComponentTypeModuleProvider;
import com.ericsson.neptune.componentmgr.service.IComponentManager;
import com.ericsson.neptune.componentmgr.service.IComponentSynchronizer;
import com.ericsson.neptune.distributed.component.jaxb.ComponentType;
import com.ericsson.neptune.distributed.component.jaxb.ObjectFactory;
import com.ericsson.neptune.security.util.HttpConnUtil;
import com.tandbergtv.neptune.authorization.service.IInternalModuleSynchronizer;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.realm.persist.Component;
import com.tandbergtv.neptune.validation.ValidationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

@Stateless
public class ComponentSynchronizer
implements IComponentSynchronizer {
    private static final Logger logger = Logger.getLogger(ComponentSynchronizer.class);
    @EJB
    private IComponentManager componentManager;
    @EJB
    private IConfigurationService configurationService;
    @EJB
    private IInternalModuleSynchronizer moduleSyncService;
    private static final String NEPTUNE_COMPONENT_REG_DIR = "neptune/componentRegistration";
    private static final String REGISTRATION_SERVICE_LOCATOR = "/component";
    private static final String REMOTE_COMPONENTS_SETTING = "com.ericsson.cms.neptune.remotecomponents";
    private static int connection_timeout = 15000;
    @EJB
    private ISettingsService settingsService;
    @EJB
    private ILicenseManager licenseManager;
    Boolean isRCSOnly = null;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void synchronize() {
        try {
            connection_timeout = Integer.parseInt((String)this.settingsService.getProperties(REMOTE_COMPONENTS_SETTING).get("connection_timeout"));
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to parse setting com.ericsson.cms.neptune.remotecomponents. Using default value " + connection_timeout), (Throwable)ex);
        }
        this.moduleSyncService.synchronize();
        List<Component> components = this.getComponents();
        File registrationDir = this.getRegistrationDir();
        if (!registrationDir.exists() && !registrationDir.mkdirs()) {
            logger.error((Object)("Unable to create registration directory [" + registrationDir.getAbsolutePath() + "]"));
        }
        for (File regFile : registrationDir.listFiles()) {
            if (regFile.delete()) continue;
            logger.error((Object)("Unable to delete registration file " + regFile.getAbsolutePath()));
        }
        if (this.isRCSOnly == null) {
            this.isRCSOnly = Boolean.FALSE;
            try {
                if (Boolean.parseBoolean(this.licenseManager.getProperty("IsRCSOnly"))) {
                    this.isRCSOnly = Boolean.TRUE;
                }
            }
            catch (InvalidLicenseException e) {
                logger.error((Object)"Could not read license...assuming that IsRCSOnly is false", (Throwable)e);
            }
        }
        for (Component component : components) {
            logger.debug((Object)("Synchronizing component [" + component.getName() + "]"));
            ComponentType next = this.getRegistrationData(component, registrationDir);
            if (next == null) continue;
            if (this.isRCSOnly.booleanValue() && !"EPG".equalsIgnoreCase(component.getName())) {
                logger.warn((Object)("This system is licensed for 'RCS Only' deployment, " + component.getName() + " would not be synchronized."));
                this.deleteComponentRegistrationData(Arrays.asList(component.getName()));
                continue;
            }
            this.moduleSyncService.synchronize(component.getId(), (IModuleProvider)new ComponentTypeModuleProvider(next));
        }
        this.moduleSyncService.updateAdministratorRoles();
        this.moduleSyncService.updateServicesUserRoles();
    }

    public boolean updateRegistration(String componentName) {
        Component component = this.componentManager.getComponent(componentName);
        if (null == component) {
            logger.error((Object)("Could not update registration for component - No component exists with name " + componentName));
            return false;
        }
        ComponentType componentType = this.getRegistrationData(component, this.getRegistrationDir());
        if (componentType != null) {
            this.moduleSyncService.synchronize(component.getId(), (IModuleProvider)new ComponentTypeModuleProvider(componentType));
            this.moduleSyncService.updateAdministratorRoles();
            this.moduleSyncService.updateServicesUserRoles();
            return true;
        }
        return false;
    }

    public List<ComponentType> getComponentRegistrationData() {
        ArrayList<ComponentType> components = new ArrayList<ComponentType>();
        File registrationDir = this.getRegistrationDir();
        for (File regFile : registrationDir.listFiles()) {
            try {
                ComponentType component = this.unmarshallComponentType(regFile);
                if (component == null) continue;
                components.add(component);
            }
            catch (Exception e) {
                logger.error((Object)("Could not read Registration file " + regFile.getAbsolutePath() + ".  " + e.getLocalizedMessage()));
            }
        }
        return components;
    }

    public void deleteComponentRegistrationData(List<String> componentNames) {
        File regDir = this.getRegistrationDir();
        for (String name : componentNames) {
            File regFile = new File(regDir, name);
            regFile.delete();
        }
    }

    private String getRegistrationUrl(Component component) {
        String baseURL = component.getBaseURL();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + component.getName() + REGISTRATION_SERVICE_LOCATOR;
    }

    private List<Component> getComponents() {
        List components = this.componentManager.getComponents();
        return components;
    }

    private File getRegistrationDir() {
        return this.configurationService.getFile(NEPTUNE_COMPONENT_REG_DIR);
    }

    private Unmarshaller getComponentTypeUnmarshaller() throws JAXBException {
        Class<ObjectFactory> factoryClass = ObjectFactory.class;
        JAXBContext jaxbContext = JAXBContext.newInstance((String)factoryClass.getPackage().getName(), (ClassLoader)factoryClass.getClassLoader());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return unmarshaller;
    }

    private ComponentType unmarshallComponentType(File input) {
        ComponentType componentType = null;
        try {
            JAXBElement element = (JAXBElement)this.getComponentTypeUnmarshaller().unmarshal(input);
            componentType = (ComponentType)element.getValue();
        }
        catch (JAXBException e) {
            logger.error((Object)("Could not parse registration data " + e.getLocalizedMessage()));
        }
        return componentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentType getRegistrationData(Component component, File regDir) {
        ComponentType componentType = null;
        BufferedReader reader = null;
        component.setStatusId(IComponentManager.ComponentStatusType.INACTIVE.id());
        String url = this.getRegistrationUrl(component);
        BufferedWriter bw = null;
        try {
            File regFile = new File(regDir, component.getName());
            regFile.delete();
            HttpURLConnection conn = this.createConnection(url);
            conn.connect();
            StringBuilder buff = new StringBuilder();
            String xmlResponse = "";
            if (conn.getResponseCode() == 200) {
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buff.append(line);
                }
                xmlResponse = buff.toString();
                JAXBElement element = (JAXBElement)this.getComponentTypeUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(xmlResponse)));
                componentType = (ComponentType)element.getValue();
                bw = new BufferedWriter(new FileWriter(regFile));
                bw.write(xmlResponse);
                component.setStatusId(IComponentManager.ComponentStatusType.ACTIVE.id());
                component.setLastSuccessfulSynchTimestamp(new Date());
                logger.debug((Object)("Component [" + component.getName() + "] is Active"));
            } else {
                logger.error((Object)("Component [" + component.getName() + "] registration response error : " + conn.getResponseMessage()));
            }
        }
        catch (JAXBException e) {
            logger.error((Object)("Could not parse registration data " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("Component registration failed for " + component.getName() + " at " + url + ".  " + e.getLocalizedMessage()));
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    logger.error((Object)("Error closing registration file for " + component.getName() + ".  " + e.getLocalizedMessage()));
                }
            }
        }
        try {
            this.componentManager.update(component);
        }
        catch (ValidationException e) {
            logger.error((Object)("Failed to set status for Component " + component.getName() + ".  " + e.getLocalizedMessage()));
        }
        return componentType;
    }

    private HttpURLConnection createConnection(String url) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpURLConnection conn = HttpConnUtil.openHttpConnection((String)url);
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/text");
        conn.setConnectTimeout(connection_timeout);
        conn.setReadTimeout(connection_timeout);
        return conn;
    }
}

