/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.componentmgr.ejb;

import com.ericsson.neptune.componentmgr.service.IComponentSynchronizer;
import com.ericsson.neptune.componentmgr.service.internal.IJBossComponentSynchronizer;
import com.ericsson.neptune.distributed.component.jaxb.ComponentType;
import com.tandbergtv.neptune.actionItems.cache.Cluster;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.apache.log4j.Logger;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.realm.conf.IRealmConfigurationService", "Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService"})
public class JBossComponentSynchronizer
implements IJBossComponentSynchronizer {
    private static final Logger logger = Logger.getLogger(JBossComponentSynchronizer.class);
    @EJB
    private IComponentSynchronizer componentSynchronizer;
    @EJB
    private ISettingsService settingsService;
    ScheduledExecutorService scheduledExecutorService;
    static final String REMOTE_COMPONENTS_SETTING = "com.ericsson.cms.neptune.remotecomponents";
    private int retry_frequency = 180;

    @Override
    @PostConstruct
    public void start() throws Exception {
        this.synchronize();
    }

    public void synchronize() {
        try {
            this.retry_frequency = Integer.parseInt((String)this.settingsService.getProperties(REMOTE_COMPONENTS_SETTING).get("retry_frequency"));
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to parse setting retry_frequency. Using default value " + this.retry_frequency), (Throwable)ex);
        }
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (Cluster.isMaster()) {
                    logger.info((Object)"Component Synchronizer thread running..");
                    JBossComponentSynchronizer.this.componentSynchronizer.synchronize();
                }
            }
        }, 0L, this.retry_frequency, TimeUnit.SECONDS);
    }

    public List<ComponentType> getComponentRegistrationData() {
        return this.componentSynchronizer.getComponentRegistrationData();
    }

    public boolean updateRegistration(String componentName) {
        return this.componentSynchronizer.updateRegistration(componentName);
    }

    public void deleteComponentRegistrationData(List<String> componentNames) {
        this.componentSynchronizer.deleteComponentRegistrationData(componentNames);
    }

    @Override
    @PreDestroy
    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    public int getRetry_frequency() {
        return this.retry_frequency;
    }
}

