/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.jaas.ejb;

import com.ericsson.neptune.clustermgmt.service.IClusterConfigurationService;
import com.ericsson.neptune.jaas.IJBossJAASService;
import com.ericsson.neptune.jaas.UserPrincipalMessage;
import com.ericsson.neptune.jaas.UserPrincipalMessageListener;
import com.ericsson.neptune.jmx.MBeanInvoker;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.security.Principal;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import org.apache.log4j.Logger;

@Local(value={IJBossJAASService.class})
@Singleton
@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService"})
public class JBossJAASService
implements IJBossJAASService {
    public static final String SECURITY_DOMAIN_CMS = "cms";
    public static final String OPERATION_FLUSH_AUTHENTICATION_CACHE = "flushCache";
    public static final String OBJECT_NAME_JAAS_SECURITY_MANAGER = "jboss.as:subsystem=security,security-domain=cms";
    private static final String USER_PRINCIPAL_OPERATION_TOPIC = "user-principal-operation-topic";
    private static Logger logger = Logger.getLogger(JBossJAASService.class);
    private MBeanInvoker mbeanInvoker;
    private UserPrincipalMessageListener messageListener;
    @EJB
    private IClusterConfigurationService clusterConfigurationService;

    public void flushCache(String username) {
        try {
            this.mbeanInvoker.invokeOperation(OBJECT_NAME_JAAS_SECURITY_MANAGER, OPERATION_FLUSH_AUTHENTICATION_CACHE, new Object[]{SECURITY_DOMAIN_CMS, username}, new String[]{String.class.getName(), Principal.class.getName()});
        }
        catch (Exception e) {
            logger.warn((Object)"Fail to flush JBoss cache", (Throwable)e);
        }
    }

    public void flushCache() {
        try {
            this.mbeanInvoker.invokeOperation(OBJECT_NAME_JAAS_SECURITY_MANAGER, OPERATION_FLUSH_AUTHENTICATION_CACHE, new Object[]{SECURITY_DOMAIN_CMS}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            logger.warn((Object)"Fail to flush JBoss cache", (Throwable)e);
        }
    }

    @PostConstruct
    public void start() throws Exception {
        this.mbeanInvoker = new MBeanInvoker();
        this.messageListener = new UserPrincipalMessageListener((IJBossJAASService)this);
        ITopic topic = this.clusterConfigurationService.getHazelcastInstance().getTopic(USER_PRINCIPAL_OPERATION_TOPIC);
        topic.addMessageListener((MessageListener)this.messageListener);
    }

    @PreDestroy
    public void stop() {
    }

    public void notifyFlushCache() {
        try {
            this.clusterConfigurationService.getHazelcastInstance().getTopic(USER_PRINCIPAL_OPERATION_TOPIC).publish((Object)new UserPrincipalMessage());
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot notify to flush cache", (Throwable)e);
        }
    }

    public void setMbeanInvoker(MBeanInvoker mbeanInvoker) {
        this.mbeanInvoker = mbeanInvoker;
    }

    public void setClusterConfigurationService(IClusterConfigurationService clusterConfigurationService) {
        this.clusterConfigurationService = clusterConfigurationService;
    }
}

