/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserConfigurationMode;
import com.tandbergtv.neptune.usermgmt.ejb.UserManager;
import com.tandbergtv.neptune.usermgmt.service.IUserValidityService;
import com.tandbergtv.neptune.usermgmt.service.UserValidationException;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

class UserValidator {
    private final UserManager userManager;
    private static final int USERNAME_MIN_LENGTH = 3;
    private static final int USERNAME_MAX_LENGTH = 16;
    private static final int PASSWORD_MIN_LENGTH = 8;
    private static final int PASSWORD_MAX_LENGTH = 16;
    private static final String ALPHABET_PATTERN = "(.*)([a-zA-Z]+)(.*)";
    private static final String NUMERIC_PATTERN = "(.*)([0-9]+)(.*)";

    UserValidator(UserManager userManager) {
        this.userManager = userManager;
    }

    void validateUser(User user) throws ValidationException {
        this.validate(user, null, true);
    }

    void validateUser(User user, User persistedUser) throws ValidationException {
        this.validate(user, persistedUser, true);
    }

    void validateUserWithoutPassword(User user, User persistedUser) throws ValidationException {
        this.validate(user, persistedUser, false);
    }

    public void validateExternalUser(User user) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>(10);
        this.validateUserName(user, null, validationMessages);
        this.validateFirstName(user, null, validationMessages);
        this.validateLastName(user, null, validationMessages);
        this.validateActiveStatus(user, null, validationMessages);
        this.validateEmail(user, null, validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validate(User user, User persistedUser, boolean validatePassword) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        this.validateExternalKey(user, persistedUser);
        this.validateUserEditor(user, persistedUser);
        this.validateUserName(user, persistedUser, validationMessages);
        if (validatePassword) {
            this.validatePassword(user, persistedUser, validationMessages);
        }
        this.validateRoles(user, persistedUser, validationMessages);
        this.validateFirstName(user, persistedUser, validationMessages);
        this.validateLastName(user, persistedUser, validationMessages);
        this.validateActiveStatus(user, persistedUser, validationMessages);
        this.validateEmail(user, persistedUser, validationMessages);
        if (validationMessages.isEmpty()) {
            this.validateWithUserValidityService(user, persistedUser, validationMessages);
        }
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateExternalKey(User user, User persistedUser) throws ValidationException {
        String externalKey = user.getExternalKey();
        if (persistedUser != null) {
            if (!this.isEqual(externalKey, persistedUser.getExternalKey())) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("External Key cannot be changed for an existing user.");
                throw new ValidationException(messages);
            }
        } else if (externalKey != null) {
            UserConfigurationMode mode = this.userManager.getUserConfigurationMode();
            if (!UserConfigurationMode.External.equals((Object)mode) || this.isAdminUser(user, persistedUser)) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("External Key cannot be set for the user.");
                throw new ValidationException(messages);
            }
            User existingUser = this.userManager.findByExternalKey(externalKey);
            if (existingUser != null && !existingUser.equals((Object)user)) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("External Key already exists.");
                throw new ValidationException(messages);
            }
        }
        if (externalKey != null) {
            user.setExternallyAuthenticated(true);
        }
    }

    private void validateUserEditor(User user, User persistedUser) throws ValidationException {
        String adminUserName;
        String currentUser = this.userManager.getCurrentUser();
        if (this.isAdminUser(user, persistedUser) && !(adminUserName = this.userManager.getAdministratorUserName()).equals(currentUser)) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("User can only be edited by system administrator user: " + adminUserName);
            throw new ValidationException(messages);
        }
    }

    private void validateUserName(User user, User persistedUser, List<String> messages) {
        String userName = user.getUserName();
        if (persistedUser != null) {
            if (!this.isEqual(persistedUser.getUserName(), userName)) {
                messages.add("User Name cannot be changed for an existing user.");
                return;
            }
        } else {
            int length;
            if (this.isBlank(userName)) {
                messages.add("User Name is required.");
                return;
            }
            if (!(user.isExternallyAuthenticated() || (length = userName.length()) >= 3 && length <= 16)) {
                messages.add("User Name must be between 3 and 16 characters.");
                return;
            }
            User existingUser = this.userManager.getUser(userName);
            if (existingUser != null && !existingUser.equals((Object)user)) {
                messages.add("User Name already exists.");
                return;
            }
        }
    }

    private void validatePassword(User user, User persistedUser, List<String> messages) {
        String password = user.getPassword();
        if (user.isExternallyAuthenticated()) {
            if (password != null) {
                messages.add("Password cannot be set for this externally authenticated user.");
                return;
            }
        } else {
            String userName;
            boolean hasDigit;
            boolean hasAlphabet;
            if (this.isBlank(password)) {
                messages.add("Password is required.");
                return;
            }
            int length = password.length();
            if (length < 8 || length > 16) {
                messages.add("Password must be between 8 and 16 characters.");
            }
            if (!(hasAlphabet = password.matches(ALPHABET_PATTERN))) {
                messages.add("Password must contain at least one alphabet.");
            }
            if (!(hasDigit = password.matches(NUMERIC_PATTERN))) {
                messages.add("Password must contain at least one digit.");
            }
            if (password.equalsIgnoreCase(userName = user.getUserName())) {
                messages.add("User Name and password cannot be the same, case-insensitive");
            }
        }
    }

    private void validateRoles(User user, User persistedUser, List<String> messages) {
        Set roles = user.getRoles();
        if (roles == null || roles.isEmpty()) {
            messages.add("The user must have at least one role.");
            return;
        }
        if (persistedUser != null && this.isAdminUser(user, persistedUser)) {
            Set persistedRoles = persistedUser.getRoles();
            String userName = persistedUser.getUserName();
            if (!roles.containsAll(persistedRoles) || !persistedRoles.containsAll(roles)) {
                messages.add("Roles cannot be changed for system administrator user: " + userName);
                return;
            }
        }
    }

    private void validateFirstName(User user, User persistedUser, List<String> messages) {
        String firstName = user.getFirstName();
        if (user.getExternalKey() == null && this.isBlank(firstName)) {
            messages.add("First Name is required.");
        }
    }

    private void validateLastName(User user, User persistedUser, List<String> messages) {
        String lastName = user.getLastName();
        if (user.getExternalKey() == null && this.isBlank(lastName)) {
            messages.add("Last Name is required.");
        }
    }

    private void validateActiveStatus(User user, User persistedUser, List<String> messages) {
        boolean active = user.isActive();
        if (this.isAdminUser(user, persistedUser) && !active) {
            String adminUserName = this.userManager.getAdministratorUserName();
            messages.add("Active status must be set for system administrator user: " + adminUserName);
        }
    }

    private void validateEmail(User user, User persistedUser, List<String> messages) {
        String email = user.getEmail();
        if (user.getExternalKey() == null) {
            if (this.isBlank(email)) {
                messages.add("Email is required.");
            } else if (!email.matches("^.+@.+$")) {
                messages.add("Email is not valid.");
            }
        }
    }

    private void validateWithUserValidityService(User user, User persistedUser, List<String> messages) {
        this.userManager.updateUserRoles(user);
        for (IUserValidityService service : ServiceLoader.load(IUserValidityService.class)) {
            try {
                service.validate(user);
            }
            catch (UserValidationException e) {
                messages.add(e.getLocalizedMessage());
            }
        }
    }

    private boolean isAdminUser(User user, User persistedUser) {
        String adminUserName = this.userManager.getAdministratorUserName();
        String userName = user.getUserName();
        if (persistedUser != null) {
            userName = persistedUser.getUserName();
        }
        return adminUserName != null && adminUserName.equals(userName);
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isEqual(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value1.equals(value2);
    }
}

