/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.realm.persist.Setting;
import com.tandbergtv.neptune.realm.persist.SettingGroup;
import com.tandbergtv.neptune.settings.cache.SettingsChangeHazelcastMessage;
import com.tandbergtv.neptune.settings.cache.SettingsMessageListener;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SettingsCache {
    private static final Logger logger = Logger.getLogger(SettingsCache.class);
    private static Map<String, Map<String, String>> settingsGroupCache = new ConcurrentHashMap<String, Map<String, String>>();
    private static String DISTRIBUTED_SETTINGS_UPDATE_TOPIC_NAME = "SETTINGS_UPDATE_TOPIC";
    private static ITopic<SettingsChangeHazelcastMessage> settingsUpdateTopic;
    private static SettingsMessageListener settingsMsgListener;
    private static SettingsCache instance;

    private SettingsCache() {
    }

    public static SettingsCache getInstance() {
        if (instance == null) {
            SettingsCache.init();
        }
        return instance;
    }

    private static synchronized void init() {
        if (instance != null) {
            return;
        }
        logger.debug((Object)"SettingsCache init() called");
        instance = new SettingsCache();
        settingsUpdateTopic = Hazelcast.getTopic((String)DISTRIBUTED_SETTINGS_UPDATE_TOPIC_NAME);
        settingsMsgListener = new SettingsMessageListener();
        settingsUpdateTopic.addMessageListener((MessageListener)settingsMsgListener);
    }

    public void cacheGroup(SettingGroup group) {
        if (group == null) {
            return;
        }
        String groupPath = group.getPath();
        if (settingsGroupCache.get(groupPath) == null) {
            settingsGroupCache.put(groupPath, new ConcurrentHashMap());
        }
    }

    public void cacheSetting(Setting setting) {
        this.cache(setting);
    }

    public void removeSettingCache(Setting setting) {
        if (setting == null) {
            return;
        }
        logger.info((Object)("Removing settings from cache " + setting.getName()));
        String groupPath = setting.getGroup().getPath();
        Map<String, String> groupSettings = settingsGroupCache.get(groupPath);
        if (groupSettings != null) {
            groupSettings.remove(setting.getName());
        }
    }

    public Map<String, String> readSettingsFromCache(String settingsPath) {
        Map<String, String> cachedSettigns = settingsGroupCache.get(settingsPath);
        int size = cachedSettigns == null ? 0 : cachedSettigns.size();
        HashMap<String, String> retVal = new HashMap<String, String>(size);
        if (cachedSettigns != null) {
            retVal.putAll(cachedSettigns);
        }
        return retVal;
    }

    public void publishSettingsUpdate(String settingsPath) {
        logger.debug((Object)("Publish Settings Path was called for " + settingsPath));
        SettingsChangeHazelcastMessage msg = new SettingsChangeHazelcastMessage();
        msg.setSender(Hazelcast.getCluster().getLocalMember().getInetSocketAddress());
        msg.setGroupPath(settingsPath);
        settingsUpdateTopic.publish((Object)msg);
    }

    private void cache(Setting setting) {
        if (setting == null) {
            return;
        }
        String groupPath = setting.getGroup().getPath();
        logger.debug((Object)("Caching Settings for " + groupPath + "::" + setting.getName()));
        Map<String, String> groupSettings = settingsGroupCache.get(groupPath);
        if (groupSettings == null) {
            groupSettings = new ConcurrentHashMap<String, String>();
            settingsGroupCache.put(groupPath, groupSettings);
        }
        groupSettings.put(setting.getName(), this.trimToEmpty(setting.getValue()));
    }

    public void updateGroup(String groupPath) {
        logger.debug((Object)("refresh setting cache for path[" + groupPath + "]"));
        Collection<Setting> settings = this.findSettingsByGroup(groupPath);
        ConcurrentHashMap<String, String> settingsMap = new ConcurrentHashMap<String, String>();
        if (settings != null) {
            for (Setting s : settings) {
                settingsMap.put(s.getName(), this.trimToEmpty(s.getValue()));
            }
        }
        settingsGroupCache.put(groupPath, settingsMap);
    }

    private String trimToEmpty(String value) {
        return StringUtils.trimToEmpty((String)value);
    }

    private Collection<Setting> findSettingsByGroup(String settingsPath) {
        ISettingsService settingsService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);
        Collection settings = settingsService.findSettingsByGroup(settingsPath);
        return settings;
    }

    static {
        instance = null;
    }
}

