/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.email;

import com.tandbergtv.neptune.configuration.service.INeptuneUpgradeSettings;
import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmailSettingsUpgrade
implements INeptuneUpgradeSettings {
    private static final Logger logger = Logger.getLogger(EmailSettingsUpgrade.class);
    String fileName = null;
    String confFolder = null;
    File file = null;
    private static final String JBOSS_MAIL_SMTP_HOST = "mail.smtp.host";
    private static final String JBOSS_MAIL_SMTP_PORT = "mail.smtp.port";
    private static final String JBOSS_MAIL_SENDER_ADDR = "mail.from";
    private static final String JBOSS_MAIL_SENDER_NAME = "mail.from.name";
    private static final String MAIL_SMTP_HOST = "mail_smtp_host";
    private static final String MAIL_SMTP_PORT = "mail_smtp_port";
    private static final String MAIL_SENDER_ADDR = "mail_from";
    private static final String MAIL_SENDER_NAME = "mail_from_name";

    public boolean needsUpgrade() {
        this.file = new File(this.fileName + ".upgrade");
        return !this.file.exists();
    }

    public void setCMSBaseConfFolder(String confFolder) {
        this.confFolder = confFolder;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Map<String, String> upgrade() {
        Map<Object, Object> properties = new LinkedHashMap();
        try {
            properties = this.getPropertiesFormJBossMailServiceXml();
            logger.debug((Object)("Properties from jBoss mail-service.xml.rpmsave: " + properties.toString()));
        }
        catch (Exception e) {
            logger.warn((Object)("Skipping email properties upgrade , file not found : " + this.fileName));
        }
        return properties;
    }

    public void upgradeApplied() {
        try {
            File file = new File(this.fileName);
            file.renameTo(new File(this.fileName + ".upgrade"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Map<String, String> getPropertiesFormJBossMailServiceXml() throws Exception {
        LinkedHashMap<String, String> configMap = new LinkedHashMap<String, String>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        logger.info((Object)this.fileName);
        File file = new File(this.fileName);
        Document doc = dBuilder.parse(new FileInputStream(file));
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("property");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element eElement = (Element)node;
            String key = eElement.getAttribute("name");
            if (key.equalsIgnoreCase(JBOSS_MAIL_SMTP_HOST)) {
                configMap.put(MAIL_SMTP_HOST, eElement.getAttribute("value"));
            }
            if (key.equalsIgnoreCase(JBOSS_MAIL_SMTP_PORT)) {
                configMap.put(MAIL_SMTP_PORT, eElement.getAttribute("value"));
            }
            if (key.equalsIgnoreCase(JBOSS_MAIL_SENDER_ADDR)) {
                configMap.put(MAIL_SENDER_ADDR, eElement.getAttribute("value"));
            }
            if (!key.equalsIgnoreCase(JBOSS_MAIL_SENDER_NAME)) continue;
            configMap.put(MAIL_SENDER_NAME, eElement.getAttribute("value"));
        }
        return configMap;
    }
}

