package com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model;

import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model.UiComponentKey;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Stores a Component Key
 * 
 */
public class UiComponentKey implements IsSerializable {

	private static final String ENTRY_SEPARATOR = ":::";

	private Long id;

	/**
	 * Default Constructor
	 */
	public UiComponentKey() {
		id = null;
	}

	/**
	 * Constructs a UiComponentKey with the given ID and external key
	 * 
	 * @param id The component ID
	 */
	public UiComponentKey(Long id) {
		this.id = id;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public boolean isValueAssigned() {
		return (id != null);
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return (id != null) ? (id.hashCode() + 41) : super.hashCode();
	}

	/*
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (!(obj instanceof UiComponentKey))
			return false;

		/* IDs must be equal */
		UiComponentKey other = (UiComponentKey) obj;
		return (id != null && id.equals(other.id));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return (id == null) ? "" : id.toString();
	}

	/**
	 * Parse the string generated from the toString() method of UiComponentKey to a UiComponentKey object.
	 * 
	 * @param componentKey String representation of a UiComponentKey
	 * @return The UiComponentKey object parsed from the string
	 */
	public static UiComponentKey parse(String componentKey) {
		UiComponentKey result = new UiComponentKey();

		if (componentKey == null)
			throw new RuntimeException("Cannot parse null string to UiComponentKey.");

		/*
		 * For backwards compatibility, assume entry separator can exist in string. Since external
		 * key is removed, the entry separator is no longer used. To support old bookmarks, continue
		 * to parse expecting the entry separator. Example: 45:::test should continue to be valid.
		 */
		String[] entries = componentKey.split(ENTRY_SEPARATOR, 2);
		String idValue = entries[0].trim();
		if (idValue.length() > 0)
			result.id = Long.parseLong(idValue);

		return result;
	}
}
