/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.google.common.base.Strings;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncodingUtils {
    private static final String EMPTY_STR = "";
    private static final Logger LOG = Logger.getLogger(EncodingUtils.class);

    private EncodingUtils() {
    }

    public static String findResponseEncoding(HttpURLConnection conn) {
        String contentEncoding = EMPTY_STR;
        String contentType = conn.getContentType();
        if (StringUtils.isNotBlank((String)contentType)) {
            for (String param : contentType.replaceAll("\\s+", EMPTY_STR).split(";")) {
                if (!param.startsWith("charset=")) continue;
                contentEncoding = param.split("=", 2)[1].toUpperCase();
                break;
            }
        }
        return StringUtils.trimToEmpty((String)contentEncoding);
    }

    public static String encodeURL(String rawStr, String encoding) {
        String encodedStr = EMPTY_STR;
        try {
            encodedStr = URLEncoder.encode(Strings.nullToEmpty((String)rawStr), encoding);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to encoding string " + rawStr + " with encoding: " + encoding));
            LOG.debug((Object)e);
        }
        return Strings.nullToEmpty((String)encodedStr);
    }

    public static String decodeURL(String encodedStr, String encoding) {
        String decodedStr = EMPTY_STR;
        if (Strings.isNullOrEmpty((String)encodedStr)) {
            return EMPTY_STR;
        }
        try {
            decodedStr = URLDecoder.decode(encodedStr, encoding);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to encoding string " + encodedStr + " with encoding: " + encoding));
            LOG.debug((Object)e);
        }
        return Strings.nullToEmpty((String)decodedStr);
    }

    public static String encodeBase64(String rawStr) {
        String encodedStr = EMPTY_STR;
        BASE64Encoder base64Encoder = new BASE64Encoder();
        if (Strings.isNullOrEmpty((String)rawStr)) {
            return EMPTY_STR;
        }
        try {
            encodedStr = base64Encoder.encode(rawStr.getBytes());
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e);
        }
        return encodedStr;
    }

    public static String decodeBase64(String encodedStr) {
        String decodedStr = EMPTY_STR;
        BASE64Decoder base64Decoder = new BASE64Decoder();
        if (Strings.isNullOrEmpty((String)encodedStr)) {
            return EMPTY_STR;
        }
        try {
            decodedStr = new String(base64Decoder.decodeBuffer(encodedStr));
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e);
        }
        return decodedStr;
    }
}

