/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class HttpConnUtil {
    private static final Logger LOG = Logger.getLogger(HttpConnUtil.class);

    private HttpConnUtil() {
    }

    public static HttpURLConnection openHttpConnection(String httpURL) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        URL url = new URL(httpURL);
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpsURLConnection) {
            HttpConnUtil.disableSSLChecking((HttpsURLConnection)urlConn);
            return (HttpsURLConnection)urlConn;
        }
        if (urlConn instanceof HttpURLConnection) {
            return (HttpURLConnection)urlConn;
        }
        LOG.warn((Object)("cannot parse http(s) request url from " + httpURL));
        return null;
    }

    public static HttpsURLConnection openHttpsConnection(String httpsURL) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return HttpConnUtil.openHttpsConnection(httpsURL, true);
    }

    public static HttpsURLConnection openHttpsConnection(String httpsURL, boolean checkSSL) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if (!StringUtils.startsWith((String)httpsURL, (String)"https")) {
            return null;
        }
        URL url = new URL(httpsURL);
        URLConnection urlConn = url.openConnection();
        if (!(urlConn instanceof HttpsURLConnection)) {
            return null;
        }
        if (!checkSSL) {
            HttpConnUtil.disableSSLChecking((HttpsURLConnection)urlConn);
        }
        return (HttpsURLConnection)urlConn;
    }

    private static void disableSSLChecking(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(null, new TrustManager[]{new TrustManager()}, new SecureRandom());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        conn.setSSLSocketFactory(sc.getSocketFactory());
        conn.setHostnameVerifier(allHostsValid);
    }

    private static class TrustManager
    implements X509TrustManager {
        private TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

