/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.ericsson.neptune.security.util.HttpConnUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import org.apache.log4j.Logger;

public class RestHelper {
    private static final Logger LOG = Logger.getLogger(RestHelper.class);

    public String sendRest(String httpURL, String accessToken) throws Exception {
        String emptyBody = "";
        String response = "";
        HttpURLConnection conn = null;
        try {
            conn = HttpConnUtil.openHttpConnection(httpURL);
            if (conn == null) {
                String string = "";
                return string;
            }
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (200 == conn.getResponseCode()) {
                response = this.getResponseBody(conn);
            } else {
                LOG.warn((Object)("Got unexpected response code for accessing " + httpURL));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    private String getResponseBody(HttpURLConnection con) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader br = this.getBufferReader(con);
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
        }
        return sb.toString();
    }

    private BufferedReader getBufferReader(HttpURLConnection con) throws IOException {
        try {
            return new BufferedReader(new InputStreamReader(con.getInputStream()));
        }
        catch (Exception e) {
            return new BufferedReader(new InputStreamReader(con.getErrorStream()));
        }
    }
}

