/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.AuthenticationException;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JBossJAASWebServiceFilter
extends BaseSecurityFilter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
    }

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Basic") || request.getHeader("X-SSL-Client-FINGERPRINT") != null && request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL) != null) {
            NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Session. Basic Authentication is not allowed from a remote component.");
                throw new AuthenticationException("Invalid user credentials");
            }
            String password = principal.getToken() != null ? principal.getToken() : "";
            this.logger.debug((Object)"Calling Neptune Login module");
            try {
                request.login(principal.getUserName(), password);
            }
            catch (ServletException e) {
                this.logger.error((Object)"HttpRequest login failed!", (Throwable)e);
                throw new AuthenticationException("Invalid user credentials");
            }
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

