/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.audit;

import com.ericsson.neptune.security.NeptunePrincipal;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class AbstractAuditManager {
    private static final String FORWARDED_HEADER = "X-Forwarded-For";
    private static final String NEPTUNE_PRINCIPAL_ATTRIBUTE = "neptune_sso_oauth2_principal";
    private static final String AUDIT_BUNDLE = "com.ericsson.neptune.security.audit.Audit";
    private static final String AUDIT_MANAGER_IMPL = "AuditManagerImpl";
    private static final Logger LOGGER = Logger.getLogger(AbstractAuditManager.class);
    private static AbstractAuditManager instance = AbstractAuditManager.getInstance();

    public static AbstractAuditManager getInstance() {
        if (instance == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(AUDIT_BUNDLE);
            String name = bundle.getString(AUDIT_MANAGER_IMPL);
            try {
                instance = (AbstractAuditManager)Thread.currentThread().getContextClassLoader().loadClass(name).newInstance();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"There was a problem while trying to create the AuditManager instance", (Throwable)e);
            }
        }
        return instance;
    }

    public void logAudit(Map<String, String> messageContents, HttpServletRequest request) {
        String entityType = messageContents.get("Entity Type");
        if (entityType == null) {
            this.getLogger().warn((Object)"Unable to log audit: No Entity Type found");
            return;
        }
        messageContents.remove("Entity Type");
        String entityName = messageContents.get("Entity Name");
        if (entityName == null) {
            this.getLogger().warn((Object)"Unable to log audit: No Entity Name found");
            return;
        }
        messageContents.remove("Entity Name");
        String changeType = messageContents.get("Event Type");
        if (changeType == null) {
            this.getLogger().warn((Object)"Unable to log audit: No Change Type found");
            return;
        }
        messageContents.remove("Event Type");
        String json = messageContents.get("Change Json");
        if (changeType != "Deleted" && (json == null || json.isEmpty())) {
            this.getLogger().warn((Object)"Unable to log audit: No change found");
            return;
        }
        messageContents.remove("Change Json");
        String user = ((NeptunePrincipal)AbstractAuditManager.getAttribute(request, NEPTUNE_PRINCIPAL_ATTRIBUTE)).getUserName();
        String ip = AbstractAuditManager.getClientIp(request);
        String logMessage = "[" + user + ":" + ip + "]" + " " + entityType + " [" + entityName + "] " + changeType + " ";
        for (String key : messageContents.keySet()) {
            logMessage = logMessage + key + "=" + messageContents.get(key) + ";";
        }
        logMessage = logMessage.substring(0, logMessage.length() - 1);
        if (json != null && !json.isEmpty()) {
            logMessage = logMessage + " json=" + json;
        }
        this.write(logMessage);
    }

    protected static Object getAttribute(HttpServletRequest request, String attributeName) {
        Object attribute = request.getAttribute(attributeName);
        if (attribute == null) {
            attribute = request.getSession().getAttribute(attributeName);
        }
        return attribute;
    }

    protected static String getClientIp(HttpServletRequest request) {
        int idx;
        String clientIp = request.getRemoteAddr();
        String ipList = request.getHeader(FORWARDED_HEADER);
        if (ipList != null && (idx = (clientIp = ipList).indexOf(44)) > -1) {
            clientIp = clientIp.substring(0, idx);
        }
        return clientIp;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected abstract void write(String var1);
}

