/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.StringBaseSettingType;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StringPatternValidator
extends AbstractSettingValidator {
    @Override
    public ValidationResult validate(SettingDefinition s, String value) {
        StringBaseSettingType setting = (StringBaseSettingType)s;
        ValidationResult result = new ValidationResult();
        if (value != null && !value.trim().isEmpty() && setting.getRegex() != null && !Pattern.matches(setting.getRegex(), value.trim())) {
            ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
            params.add(setting.getDisplayName());
            result.fail().addMessage("{0} must match the specified format. See help for more information.", "en", params);
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

