/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad;

import com.ericsson.neptune.usermgmt.ad.AdContextFactory;
import com.ericsson.neptune.usermgmt.ad.AdPropertiesCache;
import com.ericsson.neptune.usermgmt.ad.exception.ADException;
import com.ericsson.neptune.usermgmt.ad.model.ADUser;
import com.ericsson.neptune.usermgmt.ad.model.UserConverter;
import com.ericsson.neptune.usermgmt.ad.util.ContextUtil;
import com.ericsson.neptune.usermgmt.ad.util.NamingUtil;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;

public class AdUserManager {
    private AdContextFactory adContextFactory;
    private AdPropertiesCache adPropertiesCache;
    private UserConverter userConverter;

    public ADUser getUser(String username) throws ADException {
        LdapContext context = null;
        try {
            context = this.adContextFactory.createContext();
            String dn = NamingUtil.getUserDN(this.adPropertiesCache.get("ad.userDN"), this.adPropertiesCache.get("ad.defaultDomain"), username);
            Attributes attrs = context.getAttributes(dn, this.userConverter.getAdFields());
            ADUser aDUser = this.userConverter.toAdUser(attrs);
            return aDUser;
        }
        catch (NamingException e) {
            throw new ADException("cannot get user", e);
        }
        finally {
            ContextUtil.closeContextQuietly(context);
        }
    }

    public void setAdContextFactory(AdContextFactory adContextFactory) {
        this.adContextFactory = adContextFactory;
    }

    public void setAdPropertiesCache(AdPropertiesCache adPropertiesCache) {
        this.adPropertiesCache = adPropertiesCache;
    }

    public void setUserConverter(UserConverter userConverter) {
        this.userConverter = userConverter;
    }
}

