/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ad;

import com.ericsson.neptune.security.util.SSLUtil;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserRequestSender {
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final String KEY_CMS_SERVICE_USERNAME = "cms.service.username";
    private static final String KEY_CMS_SERVICE_PASSWORD = "cms.service.password";
    private static final String DEFAULT_URL = "https://app:8443/cms/services/users/sync";
    private static final String KEY_CMS_SERVICE_USER_SYNC_URL = "cms.service.user.sync.url";
    private static Logger logger = Logger.getLogger(UserRequestSender.class);
    private String serviceUrl = "https://app:8443/cms/services/users/sync";
    private String serviceUsername;
    private String servicePassword;

    public UserRequestSender() {
        this.loadSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        InputStream is = null;
        try {
            Properties props = new Properties();
            is = this.getClass().getResourceAsStream("UserRequestSender.properties");
            props.load(is);
            this.serviceUrl = props.getProperty(KEY_CMS_SERVICE_USER_SYNC_URL, DEFAULT_URL);
            this.serviceUsername = props.getProperty(KEY_CMS_SERVICE_USERNAME, "");
            this.servicePassword = props.getProperty(KEY_CMS_SERVICE_PASSWORD, "");
        }
        catch (Exception e) {
            try {
                logger.warn((Object)"cannot load properties for sync url, use default 'https://app:8443/cms/services/users/sync'", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public HttpURLConnection sendSyncRequest(String username) throws Exception {
        URL url = new URL(this.serviceUrl + "?username=" + username);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSLUtil.getInstance().getSslSocketFactory());
        }
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        if (StringUtils.isNotBlank((String)this.serviceUsername) && StringUtils.isNotBlank((String)this.servicePassword)) {
            conn.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64((byte[])(username + ":" + this.servicePassword).getBytes()));
        }
        conn.connect();
        return conn;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUsername() {
        return this.serviceUsername;
    }

    public String getServicePassword() {
        return this.servicePassword;
    }
}

