/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad;

import com.ericsson.neptune.usermgmt.ad.AdContextFactory;
import com.ericsson.neptune.usermgmt.ad.AdPropertiesCache;
import com.ericsson.neptune.usermgmt.ad.IAdUserManager;
import com.ericsson.neptune.usermgmt.ad.exception.ADException;
import com.ericsson.neptune.usermgmt.ad.model.ADUser;
import com.ericsson.neptune.usermgmt.ad.model.UserConverter;
import com.ericsson.neptune.usermgmt.ad.util.ContextUtil;
import com.ericsson.neptune.usermgmt.ad.util.NamingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AdUserManager
implements IAdUserManager {
    private static Logger logger = Logger.getLogger(AdUserManager.class);
    private AdContextFactory adContextFactory;
    private AdPropertiesCache adPropertiesCache;
    private UserConverter userConverter;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ADUser getUser(String username) throws ADException {
        ADUser aDUser;
        LdapContext context = null;
        try {
            Properties props = this.adPropertiesCache.getProperties();
            context = this.adContextFactory.createContext();
            String dn = NamingUtil.getUserDN(props.getProperty("ad.user.dn"), props.getProperty("ad.defaultDomain"), username);
            Attributes attrs = context.getAttributes(dn, this.userConverter.getAdFields());
            aDUser = this.userConverter.toAdUser(attrs);
        }
        catch (ADException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ADException("cannot get user", e2);
                }
            }
            catch (Throwable throwable) {
                ContextUtil.closeContextQuietly(context);
                throw throwable;
            }
        }
        ContextUtil.closeContextQuietly(context);
        return aDUser;
    }

    @Override
    public List<ADUser> searchUsers(List<String> usernames) throws ADException {
        Properties props = this.adPropertiesCache.getProperties();
        String key = props.getProperty("ad.user.username");
        if (StringUtils.isBlank((String)key)) {
            throw new ADException("property[ad.user.username] in ActiveDirectory.properties is not set yet");
        }
        if (usernames == null || usernames.isEmpty()) {
            return Collections.emptyList();
        }
        LdapContext context = null;
        try {
            context = this.adContextFactory.createContext();
            String baseDN = NamingUtil.getSearchBaseDN(props.getProperty("ad.search.baseDN"), props.getProperty("ad.defaultDomain"));
            String filter = NamingUtil.getSearchFilter(props.getProperty("ad.search.filter"), usernames, key);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(this.userConverter.getAdFields());
            logger.info((Object)("search LDAP server with base[" + baseDN + "], filter[" + filter + "]"));
            NamingEnumeration<SearchResult> searchResult = context.search(baseDN, filter, controls);
            List<ADUser> list = this.getAdUsers(searchResult);
            return list;
        }
        catch (Exception e) {
            throw new ADException("cannot get user", e);
        }
        finally {
            ContextUtil.closeContextQuietly(context);
        }
    }

    private List<ADUser> getAdUsers(NamingEnumeration<SearchResult> searchResult) {
        ArrayList<ADUser> users = new ArrayList<ADUser>(10);
        while (searchResult.hasMoreElements()) {
            SearchResult sr = (SearchResult)searchResult.nextElement();
            try {
                ADUser user = this.userConverter.toAdUser(sr.getAttributes());
                if (user == null) continue;
                users.add(user);
            }
            catch (ADException e) {
                logger.warn((Object)"cannot convert LDAP user to CMS user", (Throwable)e);
            }
        }
        return users;
    }

    public void setAdContextFactory(AdContextFactory adContextFactory) {
        this.adContextFactory = adContextFactory;
    }

    public void setAdPropertiesCache(AdPropertiesCache adPropertiesCache) {
        this.adPropertiesCache = adPropertiesCache;
    }

    public void setUserConverter(UserConverter userConverter) {
        this.userConverter = userConverter;
    }
}

