/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.sync.scan.worker;

import com.ericsson.neptune.usermgmt.ad.IAdUserManager;
import com.ericsson.neptune.usermgmt.ad.exception.ADException;
import com.ericsson.neptune.usermgmt.ad.model.ADUser;
import com.ericsson.neptune.usermgmt.ad.model.UserConverter;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BatchLDAPUserScanWorker
implements Runnable {
    private static Logger logger = Logger.getLogger(BatchLDAPUserScanWorker.class);
    private IAdUserManager adUserManager;
    private IUserManager userManager;
    private UserConverter userConverter;
    private final List<User> users;

    public BatchLDAPUserScanWorker(List<User> users) {
        this.users = users;
    }

    @Override
    public void run() {
        if (this.users == null || this.users.isEmpty()) {
            logger.info((Object)"no users to be scanned, skipping the LDAP scan task");
            return;
        }
        List<String> names = this.getUsernames(this.users);
        logger.info((Object)("scanning for users " + StringUtils.join(names, (char)',')));
        try {
            List<ADUser> adUsers = this.adUserManager.searchUsers(names);
            this.updateExternalUsers(adUsers);
        }
        catch (ADException e) {
            logger.error((Object)"cannot scan for external user changes", (Throwable)e);
            throw new RuntimeException("cannot scan user changes", e);
        }
    }

    private void updateExternalUsers(List<ADUser> adUsers) {
        Map<String, ADUser> userMap = this.toMap(adUsers);
        for (User u : this.users) {
            if (!userMap.containsKey(u.getUserName())) {
                this.deleteUser(u);
                continue;
            }
            this.updateUserRoles(u, userMap.get(u.getUserName()));
        }
    }

    private void updateUserRoles(User user, ADUser adUser) {
        Set<String> dbRoles = this.toStringSet(user.getRoles());
        if (SetUtils.isEqualSet(dbRoles, adUser.getRoles())) {
            return;
        }
        Set<Role> adRoles = this.userConverter.getRolesByName(adUser.getRoles());
        if (SetUtils.isEqualSet(dbRoles, this.toStringSet(adRoles))) {
            return;
        }
        user.setRoles(adRoles);
        try {
            this.userManager.updateExternalUser(user);
            logger.info((Object)("roles of user[" + user + "] updated."));
        }
        catch (ValidationException e) {
            logger.error((Object)("cannot update external user[" + user + "]"), (Throwable)e);
        }
    }

    private Set<String> toStringSet(Set<Role> roles) {
        if (roles == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(roles.size());
        for (Role role : roles) {
            set.add(role.getName());
        }
        return set;
    }

    private void deleteUser(User user) {
        if (this.userManager.deleteExternalUser(user.getUserKey())) {
            logger.info((Object)("deleting user[" + user + "] succeed!"));
        } else {
            logger.info((Object)("cannot delete user[" + user + "]"));
        }
    }

    private Map<String, ADUser> toMap(List<ADUser> adUsers) {
        if (adUsers == null || adUsers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ADUser> m = new HashMap<String, ADUser>(adUsers.size());
        for (ADUser u : adUsers) {
            m.put(u.getUserName(), u);
        }
        return m;
    }

    private List<String> getUsernames(List<User> users) {
        ArrayList<String> names = new ArrayList<String>(users.size());
        for (User user : users) {
            names.add(user.getUserName());
        }
        return names;
    }

    public BatchLDAPUserScanWorker setUserManager(IUserManager userManager) {
        this.userManager = userManager;
        return this;
    }

    public BatchLDAPUserScanWorker setAdUserManager(IAdUserManager adUserManager) {
        this.adUserManager = adUserManager;
        return this;
    }

    public BatchLDAPUserScanWorker setUserConverter(UserConverter userConverter) {
        this.userConverter = userConverter;
        return this;
    }
}

