/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.util;

import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import java.util.HashSet;
import java.util.Set;

public class EntityUtil {
    private EntityUtil() {
    }

    public static Set<String> toStringSet(Set<Role> roles) {
        if (roles == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(roles.size());
        for (Role role : roles) {
            set.add(role.getName());
        }
        return set;
    }

    public static User copyUser(User user) {
        if (user == null) {
            return null;
        }
        User u = new User();
        u.setId(user.getId());
        u.setExternalKey(user.getExternalKey());
        u.setUserName(user.getUserName());
        u.setPassword(user.getPassword());
        u.setPasswordModifiedDate(user.getPasswordModifiedDate());
        u.setActive(user.isActive());
        u.setFirstName(user.getFirstName());
        u.setLastName(user.getLastName());
        u.setEmail(user.getEmail());
        u.setPhone(user.getPhone());
        u.setExtension(user.getExtension());
        u.setEmployeeId(user.getEmployeeId());
        u.setDepartment(user.getDepartment());
        u.setLocation(user.getLocation());
        u.setHidden(user.isHidden());
        u.setSyncDate(user.getSyncDate());
        if (user.getRoles() != null) {
            HashSet<Role> roles = new HashSet<Role>(user.getRoles().size());
            for (Role r : user.getRoles()) {
                roles.add(EntityUtil.copyRole(r));
            }
            u.setRoles(roles);
        }
        return u;
    }

    public static Role copyRole(Role role) {
        if (role == null) {
            return null;
        }
        Role r = new Role();
        r.setId(role.getId());
        r.setName(role.getName());
        r.setDescription(role.getDescription());
        return r;
    }
}

