/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.view;

import com.google.gwt.event.shared.GwtEvent;

/**
 * User Table View event indicating that the user table view has triggered an event
 * 
 * @author Vijay Silva
 */
class UserTableViewEvent extends GwtEvent<UserTableViewEventHandler> {

	/* The handler type */
	private final EventType eventType;
	private static Type<UserTableViewEventHandler> TYPE;

	/**
	 * Constructor
	 * 
	 * @param eventType The event type
	 */
	public UserTableViewEvent(EventType eventType) {
		this.eventType = eventType;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<UserTableViewEventHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<UserTableViewEventHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<UserTableViewEventHandler> getAssociatedType() {
		return getType();
	}

	/*
	 * Fire the event
	 */
	@Override
	protected void dispatch(UserTableViewEventHandler handler) {
		if (eventType == null)
			return;

		switch (eventType) {
		case CREATE_EXTERNAL:
			handler.onCreateExternalButtonClick(this);
			break;
		case CREATE:
			handler.onCreateButtonClick(this);
			break;
		case DELETE:
			handler.onDeleteButtonClick(this);
			break;
		}
	}

	/**
	 * The event types
	 */
	static enum EventType {
		CREATE_EXTERNAL, CREATE, DELETE;
	}
}
