package com.tandbergtv.neptune.ui.realm.client.alerts.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;

public interface IAlertsUIServiceAsync extends RemoteService {

	/**
	 * @see IAlertsUIService#getAlertCounts()
	 */
	void getAlertCounts(AsyncCallback<UiAlertCounts> callback);

	/**
	 * @see IAlertsUIService#getAlertItems()
	 */
	void getAlertItems(AsyncCallback<List<UiAlertItem>> callback );

	/**
	 * @see IAlertsUIService#getAlertItems(int index, int pageSize)
	 */
	void getAlertItems(int index, int pageSize, AsyncCallback<List<UiAlertItem>> callback);
	
	/**
	 * @see IAlertsUIService#recover(UiRecoveryItem recoveryItem)
	 */
	void recover(UiRecoveryItem recoveryItem, AsyncCallback<UiAlertItem> callback);
	
	/**
	 * @see IAlertsUIService#recoverAll(List<UiRecoveryItem> recoveryItems)
	 */
	void recoverAll(List<UiRecoveryItem> recoveryItems, AsyncCallback<UiAlertItem> callback);

	
}
