/*
 * Created on Jan 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.framework.client.application;

import com.google.gwt.i18n.client.Messages;

/**
 * @author Vijay Silva
 */
public interface ApplicationMessages extends Messages {

	// ========================================================================
	// ===================== LOGIN FORM MESSAGES
	// ========================================================================

	/**
	 * The Login Form - title label
	 * 
	 * @param title The title name
	 */
	@DefaultMessage("{0}")
	String loginFormTitleLabel(String title);

	/**
	 * The Login Form - version label
	 * 
	 * @param versionNumber The version number
	 */
	String loginFormVersionLabel(String versionNumber);

	/**
	 * The Login Form - copyright label
	 */
	String loginFormCopyrightLabel();

	/**
	 * The Login Form - user name label
	 */
	String loginFormUserNameLabel();

	/**
	 * The Login Form - password label
	 */
	String loginFormPasswordLabel();

	/**
	 * The Login Form - login button label
	 */
	String loginFormLoginButtonLabel();

	/**
	 * The login form - license is expired message
	 */
	String licenseExpired();
	
	// ========================================================================
	// ===================== HEADER WIDGET MESSAGES
	// ========================================================================

	/**
	 * The Header Widget - title label
	 * 
	 * @param title The title
	 */
	@DefaultMessage("{0}")
	String headerWidgetTitleLabel(String title);

	/**
	 * The Header Widget - sub-title label
	 * 
	 * @param subtitle the sub-title
	 */
	@DefaultMessage("{0}")
	String headerWidgetSubtitleLabel(String subtitle);

	/**
	 * The Header Widget - Separator text to separate the detail section data
	 */
	@DefaultMessage("|")
	String headerWidgetDetailSeparator();

	/**
	 * The Header Widget - label indicating the currently logged-in user
	 * 
	 * @param userName The user name
	 */
	String headerWidgetCurrentUserLabel(String userName);

	/**
	 * The Header Widget - label for the About button
	 */
	String headerWidgetAboutButton();

	/**
	 * The Header Widget - label for the User Guide button
	 */
	String headerWidgetGuideButton();

	/**
	 * The Header Widget - label for the Log Out button
	 */
	String headerWidgetLogoutButton();

	// ========================================================================
	// ===================== TREE TAB PANEL MESSAGES
	// ========================================================================

	/**
	 * TreeTabPanel - Message indicating URL is invalid when the anchor is invalid
	 */
	String invalidURL();

	/**
	 * TreeTabPanel - Message indicating the application is loading the tree tab panel
	 */
	String loading();

	// ========================================================================
	// ===================== APPLICATION MESSAGES
	// ========================================================================

	/**
	 * The Application - pop up error message indicating that the user has made a unauthorized
	 * service method call.
	 */
	String notAuthorizedErrorMessage();
}
