package com.tandbergtv.cms.portal.util.locale;

import java.util.Locale;
import java.util.ResourceBundle;

import org.aspectj.lang.annotation.SuppressAjWarnings;

public aspect ResourceBundleLocaleModifier {
	private final Locale locale = Locale.getDefault();
	
	pointcut resourceBundleGetCall(String baseName): call(ResourceBundle ResourceBundle.getBundle(String)) && args(baseName);
	
	@SuppressAjWarnings("adviceDidNotMatch")
	ResourceBundle around(String baseName) : resourceBundleGetCall(baseName) {
		return ResourceBundle.getBundle(baseName, this.locale);
	}
}
