package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea;

import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esunpur
 *
 */
public class MessageArea extends Composite {

	private static final String MESSAGE_AREA_STYLE = "nwt-MessageArea"; 

	protected VerticalContainer mainContainer;
	protected ErrorPanel errorPanel;
	protected MessagePanel infoPanel;

	public MessageArea() {
		mainContainer = new VerticalContainer();
		mainContainer.addStyleName(MESSAGE_AREA_STYLE);
		errorPanel = new ErrorPanel();
		infoPanel = new MessagePanel();
		mainContainer.add(infoPanel);
		mainContainer.add(errorPanel);
		
		initWidget(mainContainer);
	}
	
	public void setErrorMessage(String message) {
		infoPanel.setVisible(false);
		if ((message != null) && !message.trim().equals("")) {
			errorPanel.setVisible(true);
			errorPanel.setText(message);
		}
		else {
			errorPanel.setVisible(false);
		}
	}

	public void setErrorHTML(String html) {
		infoPanel.setVisible(false);
		if ((html != null) && !html.trim().isEmpty()) {
			errorPanel.setVisible(true);
			errorPanel.setHTML(html);
		}
		else {
			errorPanel.setVisible(false);
		}
	}
	
	public void setInfoMessage(String message) {
		errorPanel.setVisible(false);
		if ((message != null) && !message.trim().isEmpty()) {
			infoPanel.setVisible(true);
			infoPanel.setText(message);
		}
		else {
			infoPanel.setVisible(false);
		}
	}

	public void setWidth(String width) {
		errorPanel.setWidth(width);
		infoPanel.setWidth(width);
	}
	
	public void reset() {
		errorPanel.setVisible(false);
		infoPanel.setVisible(false);
	}
}
