package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import java.util.Map;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.FrameElement;
import com.google.gwt.dom.client.Text;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;

public class IFrameView extends LazyView {
    private String defaultURL;
    private Frame widget = null;
    private Timer timeoutTimer = null;
    private boolean errorMessageAttached = false;
    static final int TIMEOUT = 30;
    Text errorMessageNode;

    public IFrameView(String defaultURL) {
        this.defaultURL = defaultURL;
        createErrorTextNode();
    }

    public void setUrl(String url) {
        setUrl(url, true);
    }

    public void setUrl(String url, boolean isChangeSrc) {
        invokeTimer();
        this.defaultURL = url;
        if (isChangeSrc && (this.widget != null)) {
            this.widget.setUrl(url);
        }
    }

    private void createErrorTextNode() {
        errorMessageNode = Document.get().createTextNode("Connection can't be established. Component might be down.");

    }

    private void invokeTimer() {
        if (timeoutTimer != null) {
            timeoutTimer.cancel();
        }
        timeoutTimer = new Timer() {
            @Override
            public void run() {
                if(widget!=null) {
                    widget.setVisible(false);
                }
                timeoutTimer = null;
                FrameElement frameElement = widget.getParent().getElement().cast();
                // widget.removeFromParent();
                if(!errorMessageAttached) {
                    frameElement.getStyle().setColor("red");
                    frameElement.appendChild(errorMessageNode);
                }

                errorMessageAttached = true;
            }
        };

        timeoutTimer.schedule(TIMEOUT * 1000);
    }

    @Override
    public String getAnchor() {
        String url = (widget != null) ? widget.getUrl() : null;
        return ((url != null) && !url.isEmpty()) ? "URL=" + URL.encode(url) : "";
    }

    @Override
    protected void setWidgetAnchor(String anchor) {
        String url = null;
        if ((anchor != null) && !anchor.isEmpty()) {
            AnchorTokenizer tokenizer = new AnchorTokenizer();
            Map<String, String> tokens = tokenizer.parseAnchor(anchor);
            url = tokens.get("URL");
        }

        if ((url == null) || url.isEmpty()) {
            if ((anchor == null) || anchor.trim().isEmpty()) {
                url = this.defaultURL;
            } else {
                url = this.defaultURL + "." + anchor;
            }
        } else {
            url = URL.decode(url);
        }

        this.widget.setUrl(url);
    }

    @Override
    protected Widget createWidget() {
        if (widget != null) {
            widget.removeFromParent();
        }
        this.widget = new FrameWidget();

        this.widget.addLoadHandler(new LoadHandler() {
            @Override
            public void onLoad(LoadEvent event) {
                if (timeoutTimer != null) {
                    timeoutTimer.cancel();
                    timeoutTimer = null;
                    errorMessageAttached = false;
                }
                errorMessageNode.removeFromParent();
                if(widget!=null) {
                    widget.setVisible(true);
                }
            }
        });

        return this.widget;
    }

    @Override
    public Frame getWidget() {
        return widget;
    }
}
