/*
 * Created on Sep 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

/**
 * Event class that indicates that the feature handler has modified one or more features. This may
 * or may not result in an update of the anchor.
 * 
 * @author Vijay Silva
 */
public class FeatureEvent {

	/* Flag indicating that the event causes an update in the anchor tokens produced */
	private boolean anchorChangeRequired = true;

	/**
	 * Creates a new feature event that also requires an anchor change
	 */
	FeatureEvent() {
		this(true);
	}

	/**
	 * Constructs a new event which results in an update of the anchor tokens
	 * 
	 * @param anchorChangeRequired true if the anchor needs to be updated, false otherwise
	 */
	FeatureEvent(boolean anchorChangeRequired) {
		this.anchorChangeRequired = anchorChangeRequired;
	}

	/**
	 * Determine if the event requires that the anchor of the table needs to be updated
	 */
	public boolean isAnchorChangeRequired() {
		return this.anchorChangeRequired;
	}
}
