/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimpleRadioButton;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link SimpleRadioButton} widget.
 * 
 * @see com.google.gwt.user.client.ui.SimpleRadioButton
 * @author Vijay Silva
 */
public class SimpleRadioButtonWidget extends SimpleRadioButton implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SimpleRadioButton#SimpleRadioButton(String)
	 */
	public SimpleRadioButtonWidget(String name) {
		super(name);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SimpleRadioButton#SimpleRadioButton(Element)
	 */
	public SimpleRadioButtonWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.SimpleRadioButton#wrap(Element)
	 */
	public static SimpleRadioButtonWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		SimpleRadioButtonWidget widget = new SimpleRadioButtonWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
