/*
 * Created on May 5, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.LazyContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewAnchorChangeHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;

/**
 * Lazy view that wraps the widget.
 * 
 * @author Vijay Silva
 */
public abstract class LazyView extends LazyContainer implements HasAnchor,
        HasViewAnchorChangeHandlers {

	/**
	 * Constructor
	 */
	public LazyView() {
	}

	@Override
	public HandlerRegistration addViewAnchorChangeHandler(ViewAnchorChangeHandler handler) {
		return addHandler(handler, ViewAnchorChangeEvent.getType());
	}

	@Override
	public void setAnchor(String anchor) {
		ensureWidget();
		setWidgetAnchor(anchor);
	}

	/**
	 * Set the anchor on the widget wrapped by this lazy view
	 * 
	 * @param anchor The anchor
	 */
	protected abstract void setWidgetAnchor(String anchor);

	/*
	 * Fire the anchor change event
	 */
	protected void fireViewAnchorChangeEvent(String anchor) {
		this.fireEvent(new ViewAnchorChangeEvent(anchor));
	}

	/*
	 * Delegate the event fired by the lazily initialized widget
	 */
	protected void delegateViewAnchorChangeEvent(ViewAnchorChangeEvent event) {
		this.delegateEvent(this, event);
	}
}
