/*
 * Created on Sep 15, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;

/**
 * Event indicating that the user has attempted to resize the page size
 * 
 * @author Vijay Silva
 */
public class PageResizeEvent extends GwtEvent<PageResizeHandler> {

	/* The Handler type */
	private static Type<PageResizeHandler> TYPE;

	private final int newPageSize;
	private final PageFeature pageFeature;

	/**
	 * Constructor
	 * 
	 * @param newPageSize The new page size
	 * @param feature The page feature that contains the current paging information
	 */
	public PageResizeEvent(int newPageSize, PageFeature feature) {
		this.newPageSize = newPageSize;
		this.pageFeature = feature;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<PageResizeHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<PageResizeHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<PageResizeHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(PageResizeHandler handler) {
		handler.onPageResize(this);
	}

	/**
	 * Get the new page size
	 * 
	 * @return The new page size
	 */
	public int getNewPageSize() {
		return this.newPageSize;
	}

	/**
	 * Get the page feature
	 * 
	 * @return The page feature
	 */
	public PageFeature getPageFeature() {
		return pageFeature;
	}
}
