package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * This panel is displayed when the user has typed in an invalid url. e.g. If the url is malformed
 * or the user does not have permissions to view that page.
 * 
 * @author spuranik
 */
public class InvalidPagePanel extends Composite implements INeptuneWidget {
	private static final String INVALID_PAGE_STYLE = "nwt-InvalidPagePanel";
	private static final String INVALID_PAGE_LABEL_STYLE = "nwt-InvalidPagePanel-label";
	private VerticalContainer container;
	private LabelWidget label;

	public InvalidPagePanel(String label) {
		super();
		container = new VerticalContainer();
		container.setStylePrimaryName(INVALID_PAGE_STYLE);
		container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.initWidget(container);

		this.label = new LabelWidget(label);
		this.label.setStyleName(INVALID_PAGE_LABEL_STYLE);

		container.add(this.label);
	}

	public void setLabel(String label) {
		this.label.setText(label);
	}
}
