/*
 * Created on May 17, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link Frame} widget.
 * 
 * @see com.google.gwt.user.client.ui.Frame
 * @author Vijay Silva
 */
public class FrameWidget extends Frame implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Frame#Frame()
	 */
	public FrameWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Frame#Frame(String)
	 */
	public FrameWidget(String url) {
		super(url);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Frame#Frame(Element)
	 */
	protected FrameWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.Frame#wrap(Element)
	 */
	public static FrameWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		FrameWidget widget = new FrameWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
