package com.tandbergtv.neptune.widgettoolkit.server.remote;

import java.util.ServiceLoader;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * This interface must be extended by all GWT RPC implementations instead of extending
 * {@link RemoteServiceServlet}. Furthermore, this interface is located by use of the
 * {@link ServiceLoader} and hence all implementations of this interface must create a
 * src/META-INF/services/com.tandbergtv.cms.portal.remote.NeptuneRemoteService file and list all
 * implementations within. The list must be newline separated with each line being the fully
 * qualified class name of the implementation.
 */
public interface NeptuneRemoteService {

	/**
	 * Gets the relative path associated with the GWT remote service for which this service provides
	 * an implementation.
	 * 
	 * @return The remote path for the GWT service
	 */
	String getRelativePath();

	/**
	 * Get the class that provides an implementation for the GWT remote service call.
	 * 
	 * @return The service implementation
	 */
	Class<?> getServiceImplementation();
}
