/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link ListBox} widget.
 * 
 * @see com.google.gwt.user.client.ui.ListBox
 * @author Vijay Silva
 */
public class SimpleListBoxWidget extends ListBox implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ListBox#ListBox()
	 */
	public SimpleListBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ListBox#ListBox(boolean)
	 */
	public SimpleListBoxWidget(boolean isMultipleSelect) {
		super(isMultipleSelect);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ListBox#ListBox(Element)
	 */
	protected SimpleListBoxWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.ListBox#wrap(Element)
	 */
	public static SimpleListBoxWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		SimpleListBoxWidget widget = new SimpleListBoxWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
